package com.bokesoft.yes.meta.json.com.listView;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.com.editview.MetaEditViewJSONHandler;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaTiledList;

public class MetaTiledListJSONHandler extends MetaEditViewJSONHandler<MetaTiledList> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTiledList meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.TILEDLIST_COUNT, meta.getCount());
		JSONHelper.writeToJSON(json, JSONConstants.TILEDLIST_ROWGAP, meta.getRowGap());
		JSONHelper.writeToJSON(json, JSONConstants.TILEDLIST_CELLGAP, meta.getCellGap());
	}
	
	@Override
	public void fromJSONImpl(MetaTiledList meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setCount(json.optInt(JSONConstants.TILEDLIST_COUNT));
		meta.setRowGap(json.optInt(JSONConstants.TILEDLIST_ROWGAP));
		meta.setCellGap(json.optInt(JSONConstants.TILEDLIST_CELLGAP));
	}
	
	@Override
	public MetaTiledList newInstance() {
		return new MetaTiledList();
	}
}
