package com.bokesoft.yes.meta.json.com.listView;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaBaseScriptJSONHandler;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaMoreItem;

public class MetaMoreItemJSONHandler extends MetaBaseScriptJSONHandler<MetaMoreItem,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaMoreItem meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.ROTATORLIST_MOREITEM_ICON, meta.getIcon(), "");
	}
	
	@Override
	public void fromJSONImpl(MetaMoreItem meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setIcon(json.optString(JSONConstants.ROTATORLIST_MOREITEM_ICON));
	}
	
	@Override
	public MetaMoreItem newInstance() {
		return new MetaMoreItem();
	}
	
}
