package com.bokesoft.yes.meta.json.com.grid;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaBaseScriptJSONHandler;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowTree;

public class MetaRowTreeJSONHandler extends MetaBaseScriptJSONHandler<MetaRowTree,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaRowTree meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TREETYPE, meta.getTreeType());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_CELLKEY, meta.getCellKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_EXPAND, meta.isExpand());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_EXPANDLEVEL, meta.getExpandLevel());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_FOREIGN, meta.getForeign());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_PARENT, meta.getParent());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_LOADMETHOD, meta.getLoadMethod());
        JSONHelper.writeToJSON(json, JSONConstants.GRID_TREEIMAGE, meta.getImage());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ONLYEXPAND, meta.getOnlyExpand());
	}
	
	@Override
	public void fromJSONImpl(MetaRowTree meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setTreeType(json.optInt(JSONConstants.GRID_TREETYPE));
		meta.setCellKey(json.optString(JSONConstants.GRID_CELLKEY));
		meta.setExpand(json.optBoolean(JSONConstants.GRID_EXPAND));
		meta.setExpandLevel(json.optInt(JSONConstants.GRID_EXPANDLEVEL));
		meta.setForeign(json.optString(JSONConstants.GRID_FOREIGN));
		meta.setParent(json.optString(JSONConstants.GRID_PARENT));
        meta.setLoadMethod(json.optString(JSONConstants.GRID_LOADMETHOD));
        meta.setImage(json.optString(JSONConstants.GRID_TREEIMAGE));
		meta.setOnlyExpand(json.optBoolean(JSONConstants.GRID_ONLYEXPAND));
	}

	@Override
	public MetaRowTree newInstance() {
		return new MetaRowTree();
	}
}
