package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.MetaTimeZoneDatePicker;

public class MetaTimeZoneDatePickerJSONHandler extends BaseComponentJSONHandler<MetaTimeZoneDatePicker>{

	@Override
	public void toJSONImpl(JSONObject json, MetaTimeZoneDatePicker meta,
			DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.TIMEZONE_SHOWTIMEOFF, meta.isShowTimeOff());
	}
	
	@Override
	public void fromJSONImpl(MetaTimeZoneDatePicker meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setShowTimeOff(json.optBoolean(JSONConstants.TIMEZONE_SHOWTIMEOFF));
	}
	
	@Override
	public MetaTimeZoneDatePicker newInstance() {
		return new MetaTimeZoneDatePicker();
	}
	
}
