package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaPopView;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaPopViewJSONHandler extends BaseComponentJSONHandler<MetaPopView> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaPopView meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaComponent root = meta.getRoot();
		if( root != null ) {
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ROOT, o);
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_POPANIM, meta.getPopAnim());
		
		MetaBaseScript onClose = meta.getOnClose();
		if( onClose != null ){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClose, onClose.getContent().trim());
		}
		
		MetaBaseScript onPostShow = meta.getOnShow();
		if( onPostShow != null ){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnPostShow, onPostShow.getContent().trim());
		}
	}
	
	@Override
	public void fromJSONImpl(MetaPopView meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_ROOT);
		if( o != null ) {
			MetaComponent root = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setRoot(root);
		}
		
		meta.setPopAnim(json.optString(JSONConstants.COMMON_POPANIM));
		
		String s = json.optString(JSONConstants.Event_OnClose);
		if( s != null ) {
			MetaBaseScript onClose = new MetaBaseScript(MetaConstants.Event_OnClose);
			onClose.setContent(s);
			meta.setOnClose(onClose);
		}
		
		s = json.optString(JSONConstants.Event_OnPostShow);
		if( s != null ) {
			MetaBaseScript onPostShow = new MetaBaseScript(MetaConstants.Event_OnPostShow);
			onPostShow.setContent(s);
			meta.setOnShow(onPostShow);
		}
	}

	@Override
	public MetaPopView newInstance() {
		return new MetaPopView();
	}

}
