package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yigo.meta.form.component.i18n.MetaI18nItem;

public class MetaI18nItemJSONHandler extends AbstractJSONHandler<MetaI18nItem,ISerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaI18nItem meta, ISerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALUE, meta.getValue());
	}
	
	@Override
	public void fromJSONImpl(MetaI18nItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setValue(json.optString(JSONConstants.COMMON_VALUE));
	}

	@Override
	public MetaI18nItem newInstance() {
		return new MetaI18nItem();
	}

}
