package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionViewRow;

public class MetaCollectionViewRowJSONHandler extends BaseComponentJSONHandler<MetaCollectionViewRow> {
	
	@Override
	public void fromJSONImpl(MetaCollectionViewRow meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setTopMargin(json.optString(JSONConstants.COMMON_TOPMARGIN));
		meta.setBackColor(json.optString(JSONConstants.COMMON_BACKCOLOR));
		meta.setSeparatorStyle(json.optString(JSONConstants.TABLEVIEW_SEPARATORSTYLE));
		meta.setSeparatorRadius(json.optInt(JSONConstants.TABLEVIEW_SEPARATORRADIUS));
		meta.setSeparatorColor(json.optString(JSONConstants.TABLEVIEW_SEPARATORCOLOR));
		meta.setSelectColor(json.optString(JSONConstants.TABLEVIEW_SELECTCOLOR));
		meta.setHighlightColor(json.optString(JSONConstants.TABLEVIEW_HIGHLIGHTCOLOR));
		
		String s = json.optString(JSONConstants.TABLEVIEW_SEPARATOROFFSET);
		if (s != null && !s.isEmpty()) {
			meta.setSeparatorOffset(DefSize.parse(s));
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_ROOT);
		if( o != null ) {
			MetaComponent root = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setRoot(root);
		}
		
		s = json.optString(JSONConstants.Event_RowClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowClick);
			script.setContent(s);
			meta.setRowClick(script);
		}
		
		s = json.optString(JSONConstants.Event_FocusRowChanged);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_FocusRowChanged);
			script.setContent(s);
			meta.setFocusRowChanged(script);
		}
		
		s = json.optString(JSONConstants.Event_RowDblClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			script.setContent(s);
			meta.setRowDblClick(script);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaCollectionViewRow meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOPMARGIN, meta.getTopMargin());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BACKCOLOR, meta.getBackColor());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_SEPARATORSTYLE, meta.getSeparatorStyle());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_SEPARATORRADIUS, meta.getSeparatorRadius());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_SEPARATORCOLOR, meta.getSeparatorColor());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_SELECTCOLOR, meta.getSelectColor());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_HIGHLIGHTCOLOR, meta.getHighlightColor());
		
		DefSize offset = meta.getSeparatorOffset();
		if( offset != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_SEPARATOROFFSET, offset.toString(), "");			
		}
		MetaComponent root = meta.getRoot();
		if( root != null ) {
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ROOT, o);
		}

		MetaBaseScript click = (MetaBaseScript) meta.getRowClick();
		if( click != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowClick, click.getContent().trim());
		}

		MetaBaseScript dbClick = meta.getRowDblClick();
		if( dbClick != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowDblClick, dbClick.getContent().trim());
		}

		MetaBaseScript rowChange = meta.getFocusRowChanged();
		if( rowChange != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_FocusRowChanged, rowChange.getContent().trim());
		}
	}

	@Override
	public MetaCollectionViewRow newInstance() {
		return new MetaCollectionViewRow();
	}
}
