package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaSubProcess;

public class MetaSubProcessJSONHandler extends MetaUserTaskJSONHandler<MetaSubProcess> {

	@Override
	public void fromJSONImpl(MetaSubProcess meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setAutoStartAction(json.optString(JSONConstants.NODE_AUTO_SUB_INSTANCE_TRIGGER));
		meta.setSubProcessKey(json.optString(JSONConstants.NODE_SUB_PROCESS_KEY));
		meta.setSyncMode(json.optInt(JSONConstants.NODE_SYNC_MODE));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaSubProcess meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NODE_AUTO_SUB_INSTANCE_TRIGGER, meta.getAutoStartAction());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_SUB_PROCESS_KEY, meta.getSubProcessKey());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_SYNC_MODE, meta.getSyncMode());
	}
	
	@Override
	public MetaSubProcess newInstance() {
		return new MetaSubProcess();
	}
}
