package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;

public class MetaSequenceFlowJSONHandler<T extends MetaSequenceFlow> extends MetaTransitionJSONHandler<T> {

	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setTrigger(json.optString(JSONConstants.ELEMENT_TRIGGER));
		meta.setState(json.optString(JSONConstants.ELEMENT_STATE));
		meta.setCondition(json.optString(JSONConstants.COMMON_CONDITION));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, T meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.ELEMENT_TRIGGER, meta.getTrigger());
		JSONHelper.writeToJSON(json, JSONConstants.ELEMENT_STATE, meta.getState());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CONDITION, meta.getCondition());
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public T newInstance() {
		return (T)new MetaSequenceFlow();
	}
}
