package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.message.MetaConsumer;
import com.bokesoft.yigo.meta.bpm.process.message.MetaNodeMessage;
import com.bokesoft.yigo.meta.bpm.process.message.MetaProducer;

public class MetaNodeMessageJSONHandler extends AbstractJSONHandler<MetaNodeMessage, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaNodeMessage meta, JSONObject json) throws Throwable {
		JSONObject o = json.optJSONObject(JSONConstants.BPM_PRODUCER);
		if(o != null){
			MetaProducer producer = BPMJSONHandlerUtil.unbuild(MetaProducer.class, o);
			meta.setProducer(producer);
		}
		o = json.optJSONObject(JSONConstants.BPM_CONSUMER);
		if(o != null){
			MetaConsumer consumer = BPMJSONHandlerUtil.unbuild(MetaConsumer.class, o);
			meta.setConsumer(consumer);
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaNodeMessage meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		
		MetaProducer producer = meta.getProducer();
		if(producer != null){
			JSONObject o = BPMJSONHandlerUtil.build(producer, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_PRODUCER, o);
		}
		MetaConsumer consumer = meta.getConsumer();
		if(consumer != null){
			JSONObject o = BPMJSONHandlerUtil.build(consumer, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_CONSUMER, o);
		}
		
	}
	
	@Override
	public MetaNodeMessage newInstance() {
		return new MetaNodeMessage();
	}
}
