package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventItem;

public class MetaEventItemJSONHandler extends AbstractJSONHandler<MetaEventItem, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaEventItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setAction(json.optString(JSONConstants.NODE_ACTION));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaEventItem meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_ACTION, meta.getAction());
	}
	
	@Override
	public MetaEventItem newInstance() {
		return new MetaEventItem();
	}
}
