package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBillDataMapInfo;

public class MetaBillDataMapInfoJSONHandler extends AbstractJSONHandler<MetaBillDataMapInfo, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaBillDataMapInfo meta, JSONObject json) throws Throwable {
		meta.setAutoStart(json.optBoolean(JSONConstants.NODE_AUTO_START_MID_MAP_INSTANCE));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setDataMapKey(json.optString(JSONConstants.NODE_DATA_MAP_KEY));
		meta.setFormKey(json.optString(JSONConstants.FORM_KEY));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaBillDataMapInfo meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_AUTO_START_MID_MAP_INSTANCE, meta.isAutoStart());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_DATA_MAP_KEY, meta.getDataMapKey());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_KEY, meta.getFormKey());
		
	}
	
	@Override
	public MetaBillDataMapInfo newInstance() {
		return new MetaBillDataMapInfo();
	}
}
