package com.bokesoft.yes.meta.json;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.tools.ve.IVEHost;

public class MetaProcessJsonSerializer {

	private MetaProcess metaProcess = null;
	
	private IVEHost veHost = null;
	
	public MetaProcessJsonSerializer(MetaProcess metaProcess, IVEHost veHost) {
		this.metaProcess = metaProcess;
		this.veHost = veHost;
	}
	
	public JSONObject serialize() throws Throwable {		
		AbstractJSONHandler<AbstractMetaObject,ISerializeContext> handler = BPMJSONHandlerMap.getHandler(MetaProcess.TAG_NAME);		
		return handler.toJSON(metaProcess, new BPMSerializeContext(metaProcess,veHost.getVE()));
	}
	
	public void setMetaProcess(MetaProcess metaProcess){
		this.metaProcess = metaProcess;
	}
	
	public void setVEHost(IVEHost veHost) {
		this.veHost = veHost;
	}
}
