/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.bpm;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractBPMElementJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTransitionGraphic;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransition;
import org.json.JSONObject;

public abstract class MetaTransitionJSONHandler<T extends MetaTransition>
extends AbstractBPMElementJSONHandler<T> {
    @Override
    public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
        super.fromJSONImpl(meta, json);
        meta.setCaption(json.optString("caption"));
        meta.setTargetNodeKey(json.optString("targetNodeKey"));
        JSONObject o = json.optJSONObject("transitionGraphic");
        if (o != null) {
            MetaTransitionGraphic graphic = BPMJSONHandlerUtil.unbuild(MetaTransitionGraphic.class, o);
            meta.setGraphic(graphic);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, T meta, BPMSerializeContext hook) throws Throwable {
        super.toJSONImpl(json, meta, hook);
        String caption = hook.getProcessString("BPM_Node", meta.getKey(), meta.getCaption());
        JSONHelper.writeToJSON((JSONObject)json, (String)"caption", (Object)caption);
        JSONHelper.writeToJSON((JSONObject)json, (String)"targetNodeKey", (Object)meta.getTargetNodeKey());
        MetaTransitionGraphic graphic = meta.getGraphic();
        if (graphic != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)graphic, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"transitionGraphic", (Object)o);
        }
    }
}

