package com.bokesoft.yes.meta.json.setting;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.setting.MetaSession;
import com.bokesoft.yigo.meta.setting.MetaSessionPara;

public class MetaSessionJSONHandler extends AbstractJSONHandler<MetaSession,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaSession meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.SESSION_PARAKEY, meta.getSessionParaKey());
		JSONHelper.writeToJSON(json, JSONConstants.SESSION_ASCLUSTER, meta.isSessionParaAsCluster());
		JSONHelper.writeToJSON(json, JSONConstants.SESSION_PROVIDER, meta.getSessionParaItemsProvider());
		
		JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.SESSION_PARAS, array);
	}

	@Override
	public MetaSession newInstance() {
		return new MetaSession();
	}

	@Override
	public void fromJSONImpl(MetaSession meta, JSONObject json) throws Throwable {
		meta.setSessionParaKey(json.optString(JSONConstants.SESSION_PARAKEY));
		meta.setSessionParaAsCluster(json.optBoolean(JSONConstants.SESSION_ASCLUSTER));
		meta.setSessionParaItemsProvider(json.optString(JSONConstants.SESSION_PROVIDER));
		
		JSONArray array = json.optJSONArray(JSONConstants.SESSION_PARAS);
		List<MetaSessionPara> list = UIJSONHandlerUtil.unbuild(MetaSessionPara.class, array);
		meta.addAll(0, list);
	}

}
