package com.bokesoft.yes.meta.json.other;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.mobiledef.encrypt.MetaEncryptPara;
import com.bokesoft.yigo.meta.mobiledef.encrypt.MetaEncryptSetting;

public class MetaEncryptSettingJSONHandler extends AbstractJSONHandler<MetaEncryptSetting,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaEncryptSetting meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.ENCRYPT_IMPL, meta.getImpl());

		JSONArray paras = new JSONArray();
		Iterator<MetaEncryptPara> iterator =  meta.iterator();
		while(iterator.hasNext()){
			MetaEncryptPara para = iterator.next();
			JSONObject o = new JSONObject();
			o.put(JSONConstants.COMMON_KEY, para.getKey());
			o.put(JSONConstants.COMMON_CONTENT, para.getContent());
			paras.put(o);
		}

		JSONHelper.writeToJSON(json, JSONConstants.ENCRYPT_PARAS, paras);
	}

	@Override
	public MetaEncryptSetting newInstance() {
		return new MetaEncryptSetting();
	}

	@Override
	public void fromJSONImpl(MetaEncryptSetting meta, JSONObject json) throws Throwable {
		meta.setImpl(json.optString(JSONConstants.ENCRYPT_IMPL));
		JSONArray paras = json.getJSONArray(JSONConstants.ENCRYPT_PARAS);
		for (int i = 0; i < paras.length(); i++) {
			JSONObject o = paras.getJSONObject(i);
			MetaEncryptPara para = new MetaEncryptPara();
			para.setKey(o.optString(JSONConstants.COMMON_KEY));
			para.setContent(o.optString(JSONConstants.COMMON_CONTENT));
			meta.add(para);
		}
	}

}
