package com.bokesoft.yes.meta.json.layout;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaComponentLayoutJSONHandler;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexGridLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;

public class MetaFlexGridLayoutJSONHandler extends MetaComponentLayoutJSONHandler{

	@Override
	public MetaComponentLayout<? extends MetaLayoutItem> newInstance() {
		return new MetaFlexGridLayout();
	}
	
	@Override
	public void toJSONImpl(JSONObject json,MetaComponentLayout<? extends MetaLayoutItem> meta, 
			DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaFlexGridLayout layout = (MetaFlexGridLayout) meta;
		
		JSONHelper.writeToJSON(json, JSONConstants.FLEXGRIDLAYOUTPANEL_COLUMNCOUNT, layout.getColumnCount());
		JSONHelper.writeToJSON(json, JSONConstants.FLEXGRIDLAYOUTPANEL_COLUMNGAP, layout.getColumnGap());
		JSONHelper.writeToJSON(json, JSONConstants.FLEXGRIDLAYOUTPANEL_ROWGAP, layout.getRowGap());
		JSONHelper.writeToJSON(json, JSONConstants.FLEXGRIDLAYOUTPANEL_ROWHEIGHT, layout.getRowHeight());
	}
	
	@Override
	public void fromJSONImpl(MetaComponentLayout<? extends MetaLayoutItem> meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		MetaFlexGridLayout layout = (MetaFlexGridLayout) meta;
		
		layout.setColumnCount(json.optInt(JSONConstants.FLEXGRIDLAYOUTPANEL_COLUMNCOUNT));
		layout.setColumnGap(json.optInt(JSONConstants.FLEXGRIDLAYOUTPANEL_COLUMNGAP));
		layout.setRowGap(json.optInt(JSONConstants.FLEXGRIDLAYOUTPANEL_ROWGAP));
		layout.setRowHeight(json.optInt(JSONConstants.FLEXGRIDLAYOUTPANEL_ROWHEIGHT));
	}

}
