package com.bokesoft.yes.meta.json.form;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.dataobject.MetaLayer;
import com.bokesoft.yigo.meta.dataobject.MetaRelation;

public class MetaRelationJSONHandler extends AbstractJSONHandler<MetaRelation,ISerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaRelation meta, ISerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DESCRIPTION, meta.getDescription());
	
		JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
	}

	@Override
	public MetaRelation newInstance() {
		return new MetaRelation();
	}

	@Override
	public void fromJSONImpl(MetaRelation meta, JSONObject json) throws Throwable {
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setDescription(json.optString(JSONConstants.COMMON_DESCRIPTION));
		
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		List<MetaLayer> list = UIJSONHandlerUtil.unbuild(MetaLayer.class, array);
		meta.addAll(0, list);
	}

}
