package com.bokesoft.yes.meta.json.form;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;

public class MetaOperationCollectionJSONHandler extends AbstractJSONHandler<MetaOperationCollection,DefaultSerializeContext> {
	
	@Override
	public void fromJSONImpl(MetaOperationCollection meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		
		meta.setVisible(json.optString(JSONConstants.OPERATION_VISIBLECNT));
		meta.setVisibleDependency(json.optString(JSONConstants.COMMON_VISIBLEDEPENDENCY));
		meta.setEnable(json.optString(JSONConstants.OPERATION_ENABLECNT));
		meta.setEnableDependency(json.optString(JSONConstants.COMMON_ENABLEDEPENDENCY));
		
		String s = json.optString(JSONConstants.OPERATION_ACTION);
		if( s != null ) {
			MetaBaseScript action = new MetaBaseScript(MetaConstants.Event_Action);
			action.setContent(s);
			meta.setAction(action);
		}
		
		meta.setIcon(json.optString(JSONConstants.OPERATION_ICON));
		meta.setSelfDisable(json.optBoolean(JSONConstants.OPERATION_SELFDISABLE));
		meta.setCssClass(json.optString(JSONConstants.OPERATION_CSSCLASS));
		
		JSONArray array = json.optJSONArray(JSONConstants.OPERATION_ITEMS);
		for( int i = 0,size = array.length();i < size;i++ ) {
			JSONObject subOptObj = array.getJSONObject(i);
			if(subOptObj.has(JSONConstants.OPERATION_ITEMS)){
				meta.add(UIJSONHandlerUtil.unbuild(MetaOperationCollection.class, subOptObj));
			}else{
				meta.add(UIJSONHandlerUtil.unbuild(MetaOperation.class, subOptObj));
			}
		}
		meta.setIconCode(json.optString(JSONConstants.COMMON_ICONCODE));
		meta.setDisplayMode(json.optInt(JSONConstants.COMMON_DISPLAYMODE));
	} 

	@Override
	public void toJSONImpl(JSONObject json, MetaOperationCollection meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		String caption = hook.getCaptionString(GroupKeyTable.STR_OPT, "", meta.getKey(), meta.getCaption(), meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
		
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_VISIBLECNT, meta.getVisible());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLEDEPENDENCY, meta.getVisibleDependency());
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_ENABLECNT, meta.getEnable());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ENABLEDEPENDENCY, meta.getEnableDependency());
		
		MetaBaseScript action = meta.getAction();
		if(action != null) {
			JSONHelper.writeToJSON(json, JSONConstants.OPERATION_ACTION, action.getContent().trim());
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_SELFDISABLE, meta.isSelfDisable());
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_CSSCLASS, meta.getCssClass());
		
		// 操作集合下面只放一层操作,太复杂不处理
		JSONArray array = new JSONArray();
		Iterator<KeyPairCompositeObject> it = meta.iterator();
		while( it.hasNext() ) {
			JSONObject o = UIJSONHandlerUtil.build(it.next(),hook);
			array.put(o);
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_ITEMS, array);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICONCODE, meta.getIconCode());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DISPLAYMODE, meta.getDisplayMode());
	}
	
	@Override
	public MetaOperationCollection newInstance() {
		return new MetaOperationCollection();
	}

}
