package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutDirection;

public class MetaLayoutDirectionJSONHandler extends MetaLayoutItemJSONHandler<MetaLayoutDirection> {

	@Override
	public void toJSONImpl(JSONObject json, MetaLayoutDirection meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALUE, meta.getValue());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, 
				meta.getHeight() != null ? meta.getHeight().toString() : null);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, 
				meta.getWidth() != null ? meta.getWidth().toString() : null);
	}
	
	@Override
	public void fromJSONImpl(MetaLayoutDirection meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setValue(json.optInt(JSONConstants.COMMON_VALUE));
		String heightStr = json.optString(JSONConstants.COMMON_HEIGHT);
		if(!heightStr.isEmpty()){
			meta.setHeight(DefSize.parse(heightStr));
		}
		String widthStr = json.optString(JSONConstants.COMMON_WIDTH);
		if(!widthStr.isEmpty()){
			meta.setWidth(DefSize.parse(widthStr));
		}
	}
	
	@Override
	public MetaLayoutDirection newInstance() {
		return new MetaLayoutDirection();
	}
}
