package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;

public class MetaTextEditorPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaTextEditorProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTextEditorProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_TEXTCASE, meta.getCaseType());		
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_EMBEDTEXT, hook.getString(GroupKeyTable.STR_EMBED, "", key, meta.getEmbedText()));
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_HOLDFOCUS, meta.isHoldFocus());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_INVALIDCHARS, meta.getInvalidChars());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_MASK, meta.getMask());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_MAXLENGTH, meta.getMaxLength());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_SHOWWORDLIMIT, meta.isShowWordLimit());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_PREICON, meta.getPreIcon());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, hook.getString(GroupKeyTable.STR_PROMPT, "", key, meta.getPromptText()));
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_SELECTONFOCUS, meta.isSelectOnFocus());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_MOBILESELECTONFOCUS, meta.isMobileSelectOnFocus());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_TRIM, meta.isTrim());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_EMBEDTEXTSIZE, meta.getEmbedTextSize());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_EMBEDTEXTCOLOR, meta.getEmbedTextColor());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_IMEOPTIONS, meta.getImeOptions());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_DISABLEKEYBOARD, meta.isDisableKeyboard());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_SUFFIX, meta.getSuffix());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_PREFIX, meta.getPrefix());
		
		MetaBaseScript onFocus = meta.getOnFocus();
		if(onFocus != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnFocus, onFocus.getContent().trim());
		}
		MetaBaseScript keyEnter = meta.getKeyEnter();
		if(keyEnter != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_KeyEnter, keyEnter.getContent().trim());
		}
	}

	@Override
	public void fromJSONImpl(MetaTextEditorProperties meta, JSONObject json) throws Throwable {
		meta.setCaseType(json.optInt(JSONConstants.TEXTEDITOR_TEXTCASE));
		meta.setEmbedText(json.optString(JSONConstants.TEXTEDITOR_EMBEDTEXT));
		meta.setHoldFocus(json.optBoolean(JSONConstants.TEXTEDITOR_HOLDFOCUS));
		meta.setIcon(json.optString(JSONConstants.TEXTEDITOR_ICON));
		meta.setInvalidChars(json.optString(JSONConstants.TEXTEDITOR_INVALIDCHARS));
		meta.setMask(json.optString(JSONConstants.TEXTEDITOR_MASK));
		meta.setMaxLength(json.optInt(JSONConstants.TEXTEDITOR_MAXLENGTH));
		meta.setShowWordLimit(json.optBoolean(JSONConstants.TEXTEDITOR_SHOWWORDLIMIT));
		meta.setPreIcon(json.optString(JSONConstants.TEXTEDITOR_PREICON));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		meta.setSelectOnFocus(json.optBoolean(JSONConstants.TEXTEDITOR_SELECTONFOCUS));
		meta.setMobileSelectOnFocus(json.optBoolean(JSONConstants.TEXTEDITOR_MOBILESELECTONFOCUS));
		meta.setTrim(json.optBoolean(JSONConstants.TEXTEDITOR_TRIM));
		meta.setEmbedTextSize(json.optInt(JSONConstants.TEXTEDITOR_EMBEDTEXTSIZE));
		meta.setEmbedTextColor(json.optString(JSONConstants.TEXTEDITOR_EMBEDTEXTCOLOR));
		meta.setImeOptions(json.optInt(JSONConstants.TEXTEDITOR_IMEOPTIONS));
		meta.setSuffix(json.optString(JSONConstants.NUMBEREDITOR_SUFFIX));
		meta.setPrefix(json.optString(JSONConstants.NUMBEREDITOR_PREFIX));
		
		Object o = json.opt(JSONConstants.TEXTEDITOR_DISABLEKEYBOARD);
		if(o != null) {
			meta.setDisableKeyboard(Boolean.parseBoolean(o.toString()));
		}
		
		String s = json.optString(JSONConstants.Event_OnFocus);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnFocus);
			script.setContent(s);
			meta.setOnFocus(script);
		}
		
		s = json.optString(JSONConstants.Event_KeyEnter);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_KeyEnter);
			script.setContent(s);
			meta.setKeyEnter(script);
		}
	}

	@Override
	public MetaTextEditorProperties newInstance() {
		return new MetaTextEditorProperties();
	}
}
