package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSliderProperties;

public class MetaSliderPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaSliderProperties>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaSliderProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.SLIDER_MAXPOS, meta.getMaxPos());
		JSONHelper.writeToJSON(json, JSONConstants.SLIDER_MINPOS, meta.getMinPos());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_STEPVALUE, meta.getStepValue());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_BARCOLOR, meta.getBarColor());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_PROGRESSCOLOR, meta.getProgressColor());
		JSONHelper.writeToJSON(json, JSONConstants.SLIDER_ALLOWMULTISELECTION, meta.isAllowMultiSelection());
	}

	@Override
	public void fromJSONImpl(MetaSliderProperties meta, JSONObject json) throws Throwable {
		meta.setMaxPos(json.optInt(JSONConstants.SLIDER_MAXPOS));
		meta.setMinPos(json.optInt(JSONConstants.SLIDER_MINPOS));
		meta.setStepValue(json.optInt(JSONConstants.PROGRESSBAR_STEPVALUE));
		meta.setBarColor(json.optString(JSONConstants.PROGRESSBAR_BARCOLOR));
		meta.setProgressColor(json.optString(JSONConstants.PROGRESSBAR_PROGRESSCOLOR));
		meta.setAllowMultiSelection(json.optBoolean(JSONConstants.SLIDER_ALLOWMULTISELECTION));
	}

	@Override
	public MetaSliderProperties newInstance() {
		return new MetaSliderProperties();
	}

}
