package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckBoxProperties;

public class MetaCheckBoxPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaCheckBoxProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaCheckBoxProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_SELECTEDICON, meta.getSelectedIcon());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_ICONLOCATION, meta.getIconLocation());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_HIDEBUTTON, meta.getIsHideButton());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_CHECKEDTYPE, meta.getCheckedType());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_UNCHECKEDTYPE, meta.getUnCheckedType());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_ENABLEHALFCHECK, meta.getEnableHalfCheck());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_ENABLECHECKALL, meta.getEnableCheckAll());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CHECK_ON_CLICK_NODE, meta.getCheckOnClickNode());
	}

	@Override
	public void fromJSONImpl(MetaCheckBoxProperties meta, JSONObject json) throws Throwable {
		meta.setIcon(json.optString(JSONConstants.BUTTON_ICON));
		meta.setIconLocation(json.optInt(JSONConstants.BUTTON_ICONLOCATION));
		meta.setSelectedIcon(json.optString(JSONConstants.CHECKBOX_SELECTEDICON));
		meta.setHideButton(json.optBoolean(JSONConstants.CHECKBOX_HIDEBUTTON));
		meta.setCheckedType(json.optString(JSONConstants.CHECKBOX_CHECKEDTYPE));
		meta.setUnCheckedType(json.optString(JSONConstants.CHECKBOX_UNCHECKEDTYPE));
		meta.setEnableHalfCheck(json.optBoolean(JSONConstants.CHECKBOX_ENABLEHALFCHECK));
		meta.setEnableCheckAll(json.optBoolean(JSONConstants.CHECKBOX_ENABLECHECKALL));
		meta.setCheckOnClickNode(json.optBoolean(JSONConstants.COMMON_CHECK_ON_CLICK_NODE));
	}

	@Override
	public MetaCheckBoxProperties newInstance() {
		return new MetaCheckBoxProperties();
	}
}


