package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaCollapseView;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaOperationBar;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaShrinkView;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaToolBarCollapse;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaToolBarExpand;

public class MetaShrinkViewJSONHandler extends BaseComponentJSONHandler<MetaShrinkView>{
	
	@Override
	public void fromJSONImpl(MetaShrinkView meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setToolBarBackColor(json.optString(JSONConstants.SHRINKVIEW_TOOLBARBACKCOLOR));
		
		String s = json.optString(JSONConstants.SHRINKVIEW_TOOLBARHEIGHT);
		if( s != null && !s.isEmpty() ) {
			meta.setToolBarHeight(DefSize.parse(s));
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.SHRINKVIEW_ROOT);
		if( o != null ) {
			MetaComponent root = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setRoot(root);
		}
		
		o = json.optJSONObject(JSONConstants.SHRINKVIEW_COLLAPSEVIEW);
		if( o != null ) {
			MetaCollapseView collapseView = UIJSONHandlerUtil.unbuild(MetaCollapseView.class, o);
			meta.setCollapseView(collapseView);
		}
		
		o = json.optJSONObject(JSONConstants.SHRINKVIEW_TOOLBARCOLLAPSE);
		if( o != null ) {
			MetaToolBarCollapse toolBarCollapse = UIJSONHandlerUtil.unbuild(MetaToolBarCollapse.class, o);
			meta.setToolBarCollapse(toolBarCollapse);
		}
		
		o = json.optJSONObject(JSONConstants.SHRINKVIEW_TOOLBAREXPAND);
		if( o != null ) {
			MetaToolBarExpand toolBarExpand = UIJSONHandlerUtil.unbuild(MetaToolBarExpand.class, o);
			meta.setToolBarExpand(toolBarExpand);
		}
		
		o = json.optJSONObject(JSONConstants.SHRINKVIEW_OPERATIONBAR);
		if( o != null ) {
			MetaOperationBar operationBar = UIJSONHandlerUtil.unbuild(MetaOperationBar.class, o);
			meta.setOperationBar(operationBar);
		}
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaShrinkView meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.SHRINKVIEW_TOOLBARBACKCOLOR, meta.getToolBarBackColor());
		
		DefSize toolBarHeight = meta.getToolBarHeight();
		if( toolBarHeight != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.SHRINKVIEW_TOOLBARHEIGHT, toolBarHeight.toString(), "");
		}
		
		MetaComponent root = meta.getRoot();
		if( root != null ) {
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			JSONHelper.writeToJSON(json, JSONConstants.SHRINKVIEW_ROOT, o);
		}
		
		MetaCollapseView collapseView = meta.getCollapseView();
		if( collapseView != null ) {
			JSONObject o = UIJSONHandlerUtil.build(collapseView,hook);
			JSONHelper.writeToJSON(json, JSONConstants.SHRINKVIEW_COLLAPSEVIEW, o);
		}
		
		MetaToolBarCollapse toolBarCollapse = meta.getToolBarCollapse();
		if( toolBarCollapse != null ) {
			JSONObject o = UIJSONHandlerUtil.build(toolBarCollapse,hook);
			JSONHelper.writeToJSON(json, JSONConstants.SHRINKVIEW_TOOLBARCOLLAPSE, o);
		}
		
		MetaToolBarExpand toolBarExpand = meta.getToolBarExpand();
		if( toolBarExpand != null ) {
			JSONObject o = UIJSONHandlerUtil.build(toolBarExpand,hook);
			JSONHelper.writeToJSON(json, JSONConstants.SHRINKVIEW_TOOLBAREXPAND, o);
		}
		
		MetaOperationBar operationBar = meta.getOperationBar();
		if( operationBar != null ) {
			JSONObject o = UIJSONHandlerUtil.build(operationBar,hook);
			JSONHelper.writeToJSON(json, JSONConstants.SHRINKVIEW_OPERATIONBAR, o);
		}
	}

	@Override
	public MetaShrinkView newInstance() {
		return new MetaShrinkView();
	}
	
}
