package com.bokesoft.yes.meta.json.com.comp;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yes.meta.json.form.MetaBaseScriptJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshHeader;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshState;

public class MetaRefreshHeaderJSONHandler extends MetaBaseScriptJSONHandler<MetaRefreshHeader, ISerializeContext>{

	@Override
	public void fromJSONImpl(MetaRefreshHeader meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		JSONObject object = json.optJSONObject(JSONConstants.COMMON_FORMAT);
		if (object!=null) {
			meta.setFormat(UIJSONHandlerUtil.unbuild(MetaFormat.class,object));
		}
		meta.setIcon(json.optString(JSONConstants.COMMON_ICON));
		meta.setText(json.optString(JSONConstants.COMMON_TEXT));
		meta.setIconLocation(json.optInt(JSONConstants.REFRESHCONTROL_ICONLOCATION));
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			List<MetaRefreshState> list = UIJSONHandlerUtil.unbuild(MetaRefreshState.class, array);
			meta.getStateCollection().addAll(0, list);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaRefreshHeader meta, ISerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		MetaFormat format = meta.getFormat();
		if (format != null) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMAT,UIJSONHandlerUtil.build(format,hook));
		}
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TEXT, meta.getText());
		JSONHelper.writeToJSON(json, JSONConstants.REFRESHCONTROL_ICONLOCATION, meta.getIconLocation());
		JSONArray items = UIJSONHandlerUtil.buildNoKeyCollection(hook, meta.getStateCollection());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, items);	
	}
	
	@Override
	public MetaRefreshHeader newInstance() {
		return new MetaRefreshHeader();
	}

}
