package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerAutoAbstain;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerAutoDeny;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerAutoPass;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerItem;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerItemCollection;

public class MetaTimerItemCollectionJSONHandler extends AbstractJSONHandler<MetaTimerItemCollection, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaTimerItemCollection meta, JSONObject json) throws Throwable {
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if(array != null){
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaTimerItem.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaTimerItem.class, jsonObject));
				}else if(MetaTimerAutoAbstain.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaTimerAutoAbstain.class, jsonObject));
				}else if(MetaTimerAutoDeny.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaTimerAutoDeny.class, jsonObject));
				}else if(MetaTimerAutoPass.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaTimerAutoPass.class, jsonObject));
				}else if(MetaTimerExternalLink.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaTimerExternalLink.class, jsonObject));
				}
			}
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTimerItemCollection meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		
		JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		
	}
	
	@Override
	public MetaTimerItemCollection newInstance() {
		return new MetaTimerItemCollection();
	}
}
