package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaLineCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelationLine;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelationNode;

public class MetaRelationNodeJSONHandler extends AbstractJSONHandler<MetaRelationNode, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaRelationNode meta, JSONObject json) throws Throwable {
		meta.setId(json.optInt(JSONConstants.COMMON_ID));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setDataobjectkey(json.optString(JSONConstants.RELATION_DATAOBJECTKEY));
		meta.setRelationkey(json.optString(JSONConstants.RELATION_RELATIONKEY));
		meta.setX(json.optInt(JSONConstants.GRAPHIC_X));
		meta.setY(json.optInt(JSONConstants.GRAPHIC_Y));
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_LINECOLLECTION);
		if(array != null){
			MetaLineCollection linecollection = new MetaLineCollection();
			linecollection.addAll(0, BPMJSONHandlerUtil.unbuild(MetaRelationLine.class, array));
			meta.setLinecollection(linecollection);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaRelationNode meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ID, meta.getId());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.RELATION_DATAOBJECTKEY, meta.getDataobjectkey());
		JSONHelper.writeToJSON(json, JSONConstants.RELATION_RELATIONKEY, meta.getRelationkey());
		JSONHelper.writeToJSON(json, JSONConstants.GRAPHIC_X, meta.getX());
		JSONHelper.writeToJSON(json, JSONConstants.GRAPHIC_Y, meta.getY());
		
		MetaLineCollection linecollection = meta.getLinecollection();
		if(linecollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, linecollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_LINECOLLECTION, array);
		}
	}
	
	@Override
	public MetaRelationNode newInstance() {
		return new MetaRelationNode();
	}
}
