package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperation;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperationExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaOperationCollection;

public class MetaOperationCollectionJSONHandler extends AbstractJSONHandler<MetaOperationCollection, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaOperationCollection meta, JSONObject json) throws Throwable {
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if(array != null){
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaBPMOperation.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaBPMOperation.class, jsonObject));
				}else if(MetaBPMOperationExternalLink.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaBPMOperationExternalLink.class, jsonObject));
				}
			}
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaOperationCollection meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		
		JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		
	}
	
	@Override
	public MetaOperationCollection newInstance() {
		return new MetaOperationCollection();
	}
}
