package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.message.MetaMessage;
import com.bokesoft.yigo.meta.bpm.process.message.MetaMessageCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageSend;

public class MetaMessageSendJSONHandler extends MetaNodeJSONHandler<MetaMessageSend> {

	@Override
	public void fromJSONImpl(MetaMessageSend meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setReceiverID(json.optInt(JSONConstants.MESSAGE_RECEIVER_ID));
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_MESSAGECOLLECTION);
		if(array != null){
			MetaMessageCollection messageCollection = new MetaMessageCollection();
			messageCollection.addAll(0, BPMJSONHandlerUtil.unbuild(MetaMessage.class, array));
			meta.setMessageCollection(messageCollection);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaMessageSend meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.MESSAGE_RECEIVER_ID, meta.getReceiverID());
		
		MetaMessageCollection messageCollection = meta.getMessageCollection();
		if(messageCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, messageCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_MESSAGECOLLECTION, array);
		}
	}
	
	@Override
	public MetaMessageSend newInstance() {
		return new MetaMessageSend();
	}
}
