package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaDirectAuditCondition;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTableTrigger;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAudit;

public class MetaAuditJSONHandler<T extends MetaAudit> extends MetaUserTaskJSONHandler<T> {

	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setDenyNodeKey(json.optString(JSONConstants.NODE_DENY_NODE_KEY));
		meta.setDenyToLastNode(json.optBoolean(JSONConstants.NODE_DENY_TO_LAST_NODE));
		meta.setDirectAudit(json.optBoolean(JSONConstants.DIRECT_AUDIT));
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_DIRECTAUDITCONDITION);
		if(array != null){
			MetaDirectAuditCondition directAuditCondition = new MetaDirectAuditCondition();
			directAuditCondition.addAll(BPMJSONHandlerUtil.unbuild(MetaTableTrigger.class, array));
			meta.setDirectAuditCondition(directAuditCondition);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, T meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NODE_DENY_NODE_KEY, meta.getDenyNodeKey());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_DENY_TO_LAST_NODE, meta.isDenyToLastNode());
		JSONHelper.writeToJSON(json, JSONConstants.DIRECT_AUDIT, meta.isDirectAudit());
		
		MetaDirectAuditCondition directAuditCondition = meta.getDirectAuditCondition();
		if(directAuditCondition != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, directAuditCondition);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_DIRECTAUDITCONDITION, array);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public T newInstance() {
		return (T) new MetaAudit();
	}
}
