package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAssistanceCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAudit;
import com.bokesoft.yigo.meta.bpm.process.node.MetaCountersign;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;

public class MetaAssistanceCollectionJSONHandler extends AbstractJSONHandler<MetaAssistanceCollection, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaAssistanceCollection meta, JSONObject json) throws Throwable {
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if(array != null){
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaAudit.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaAudit.class, jsonObject));
				}else if(MetaCountersign.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaCountersign.class, jsonObject));
				}else if(MetaUserTask.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaUserTask.class, jsonObject));
				}
			}
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaAssistanceCollection meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		
		JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		
	}
	
	@Override
	public MetaAssistanceCollection newInstance() {
		return new MetaAssistanceCollection();
	}
}
