/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.automap.excel.template.out.column;

import com.bokesoft.yigo.common.struct.IKeyPair;
import java.util.List;

public abstract class AbstractColumnData<M extends IKeyPair> {
    private int row = 0;
    private int col = 0;
    private int rowSpan = 1;
    private int colSpan = 1;
    protected M meta = null;
    private AbstractColumnData<M> parent = null;
    protected List<AbstractColumnData<M>> children = null;

    public AbstractColumnData(M m) {
        this.meta = m;
    }

    public String getKey() {
        return this.meta.getKey();
    }

    public M getMeta() {
        return this.meta;
    }

    public void setParent(AbstractColumnData<M> abstractColumnData) {
        this.parent = abstractColumnData;
    }

    public AbstractColumnData<M> getParent() {
        return this.parent;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int n) {
        this.row = n;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int n) {
        this.col = n;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int n) {
        this.rowSpan = n;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int n) {
        this.colSpan = n;
    }

    public List<AbstractColumnData<M>> getChildren() {
        if (!this.hasChildren()) {
            return null;
        }
        this.prepareChildren();
        return this.children;
    }

    public int getDeep() {
        if (!this.hasChildren()) {
            return 1;
        }
        int n = 0;
        this.prepareChildren();
        for (AbstractColumnData<M> abstractColumnData : this.children) {
            n = Math.max(n, abstractColumnData.getDeep() + 1);
        }
        return n;
    }

    public int getLeafCount() {
        if (!this.hasChildren()) {
            return 1;
        }
        int n = 0;
        this.prepareChildren();
        for (AbstractColumnData<M> abstractColumnData : this.children) {
            n += abstractColumnData.getLeafCount();
        }
        return n;
    }

    public abstract String getCaption();

    public abstract boolean hasChildren();

    public abstract boolean isExpandColumn();

    protected abstract void prepareChildren();
}

