/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template.builder;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.builder.IExcelTemplateBuilder;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import java.util.ArrayList;

public abstract class AbstractBatchTemplateBuilder
implements IExcelTemplateBuilder {
    protected MetaExcelWorkbook metaWorkbook = null;
    protected MetaDataObject dataObject = null;

    public AbstractBatchTemplateBuilder(MetaExcelWorkbook metaWorkbook, MetaDataObject dataObject) {
        this.metaWorkbook = metaWorkbook;
        this.dataObject = dataObject;
    }

    protected ExcelTemplateTable ensureTemplateTable4Batch(ExcelTemplateSheet sheetTemplate, String tableKey) {
        ExcelTemplateTable templateTable = sheetTemplate.ensureTemplateTable(tableKey);
        if (!StringUtil.isBlankOrNull((String)tableKey)) {
            templateTable.setDtlTable(true);
            templateTable.setStartDtlRowIndex(3);
        }
        return templateTable;
    }

    protected void resetBatchFields(ExcelTemplate excelTemplate, boolean bNeedResetColumnIndex) {
        int preTableLastColumnIndex = 1;
        for (ExcelTemplateSheet templateSheet : excelTemplate.getTemplateSheets()) {
            ExcelTemplateTable noSourceTemplateTable = templateSheet.ensureTemplateTable("");
            for (ExcelTemplateTable tTable : templateSheet.getTemplateTables()) {
                if (!StringUtil.isBlankOrNull((String)tTable.getTableKey())) {
                    ArrayList<ExcelTemplateField> noSourceFields = new ArrayList<ExcelTemplateField>();
                    for (ExcelTemplateField field : tTable.getFields()) {
                        if (bNeedResetColumnIndex) {
                            field.setColIndex(preTableLastColumnIndex + field.getColIndex());
                        }
                        if (field.getSourceType() != 2) continue;
                        noSourceFields.add(field);
                    }
                    for (ExcelTemplateField field : noSourceFields) {
                        tTable.remove(field);
                        noSourceTemplateTable.addField(field);
                    }
                }
                preTableLastColumnIndex += tTable.getFieldCount();
            }
        }
    }
}

