/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.tools.document;

import com.bokesoft.yes.common.util.DBDataConvertor;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DocumentUtil {
    private static final List<String> systemFields = new ArrayList<String>();

    @Deprecated
    public static Document newDocument(String formKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        MetaDataSource dataSource = metaForm.getDataSource();
        if (dataSource == null) {
            return null;
        }
        return DocumentUtil.newDocument(dataSource.getDataObject());
    }

    public static Document newDocument(String formKey, IMetaFactory metaFactory) throws Throwable {
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        MetaDataSource dataSource = metaForm.getDataSource();
        if (dataSource == null) {
            return null;
        }
        return DocumentUtil.newDocument(dataSource.getDataObject());
    }

    public static Document newDocument(MetaDataObject dataObject) throws Throwable {
        Document document = new Document(dataObject, -1L);
        MetaTableCollection metaTableCollection = dataObject.getTableCollection();
        Iterator it = metaTableCollection.iterator();
        MetaTable metaTable = null;
        while (it.hasNext()) {
            metaTable = (MetaTable)it.next();
            DataTable table = DataTableUtil.newEmptyDataTable(metaTable);
            if (metaTable.getTableMode() == 0) {
                DocumentUtil.newRow(metaTable, table);
            }
            document.add(metaTable.getKey(), table);
        }
        return document;
    }

    public static Document newDetailDocument(MetaDataObject dataObject, String tableKey) throws Throwable {
        Document document = new Document(dataObject, -1L);
        MetaTableCollection metaTableCollection = dataObject.getTableCollection();
        MetaTable metaTable = (MetaTable)metaTableCollection.get(tableKey);
        DataTable table = DataTableUtil.newEmptyDataTable(metaTable);
        DocumentUtil.newRow(metaTable, table);
        document.add(tableKey, table);
        return document;
    }

    public static Document resolveData(Document document) {
        MetaDataObject metaDataObject = document.getMetaDataObject();
        Long OID = document.getOID();
        Document newDoc = new Document(metaDataObject, OID.longValue());
        MetaTableCollection collection = metaDataObject.getTableCollection();
        for (MetaTable metaTable : collection) {
            String key = metaTable.getKey();
            DataTable table = document.get(key);
            DataTable shadowTable = document.getShadowTable(key);
            if (shadowTable != null) {
                newDoc.add(key, shadowTable);
                continue;
            }
            newDoc.add(key, table);
        }
        return newDoc;
    }

    public static int newRow(MetaTable metaTable, DataTable table) throws Throwable {
        int newIndex = table.append();
        Iterator itColumn = metaTable.iterator();
        String defaultValue = null;
        Object value = null;
        String key = null;
        while (itColumn.hasNext()) {
            MetaColumn metaColumn = (MetaColumn)itColumn.next();
            defaultValue = metaColumn.getDefaultValue();
            key = metaColumn.getKey();
            if (defaultValue != null) {
                if (defaultValue.isEmpty()) {
                    if (metaColumn.getDataType() == 1002 || metaColumn.getDataType() == 1011 || metaColumn.getDataType() == 1012) {
                        table.setObject(key, (Object)"");
                        continue;
                    }
                    if (!metaColumn.isNumeric() || systemFields.contains(metaColumn.getKey())) continue;
                    value = TypeConvertor.toDataType((int)metaColumn.getDataType(), (Object)0);
                    table.setObject(key, value);
                    continue;
                }
                value = DBDataConvertor.toConstValue((int)metaColumn.getDataType(), (String)defaultValue);
                table.setObject(key, value);
                continue;
            }
            if (!metaColumn.isNumeric() || systemFields.contains(key)) continue;
            value = TypeConvertor.toDataType((int)metaColumn.getDataType(), (Object)0);
            table.setObject(key, value);
        }
        return newIndex;
    }

    public static void calcSequence(Document document) {
        for (MetaTable metaTable : document.getMetaDataObject().getTableCollection()) {
            if (metaTable.getTableMode() != 1 || !metaTable.containsKey("Sequence")) continue;
            DataTable dataTable = document.get(metaTable.getKey());
            int curSeq = 0;
            int seqIndex = dataTable.getMetaData().findColumnIndexByKey("Sequence");
            for (int i = 0; i < dataTable.size(); ++i) {
                dataTable.setPos(i);
                Integer sequence = (Integer)dataTable.getObject(seqIndex);
                if (sequence == null || sequence <= curSeq) {
                    sequence = curSeq + 1;
                    dataTable.setInt(seqIndex, sequence);
                }
                curSeq = sequence;
            }
        }
    }

    private static Object initValue(MetaColumn metaColumn) throws Throwable {
        Object value = null;
        String defaultValue = metaColumn.getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            value = DBDataConvertor.toConstValue((int)metaColumn.getDataType(), (String)defaultValue);
        } else if (metaColumn.isNumeric()) {
            value = TypeConvertor.toDataType((int)metaColumn.getDataType(), (Object)0);
        } else if (metaColumn.isString()) {
            value = "";
        }
        return value;
    }

    public static List<String> copyNew(Document document, MetaForm metaForm) throws Throwable {
        DataTable table;
        MetaTable metaTable;
        MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
        MetaTableCollection metaTableCollection = metaDataObject.getTableCollection();
        Iterator it = metaTableCollection.entryIterator();
        ArrayList<String> ignoreKeys = new ArrayList<String>();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            metaTable = (MetaTable)entry.getValue();
            table = document.get(metaTable.getKey());
            String parentKey = metaTable.getParentKey();
            if (parentKey == null || parentKey.isEmpty()) continue;
            MetaComponent meta = metaForm.findComponentByTable(parentKey);
            if (meta != null && !meta.isCopyNew().booleanValue()) {
                table.clear();
                table.setNew();
                continue;
            }
            DataTable parentTable = document.get(parentKey);
            HashMap<Long, Integer> bkmkMap = new HashMap<Long, Integer>();
            parentTable.beforeFirst();
            while (parentTable.next()) {
                bkmkMap.put(parentTable.getLong("OID"), parentTable.getBookmark());
            }
            table.afterLast();
            while (table.previous()) {
                if (table.getParentBookmark() != -1) continue;
                Integer parentBkmk = (Integer)bkmkMap.get(table.getLong("POID"));
                if (parentBkmk != null && parentBkmk >= 0) {
                    table.setParentBookmark(parentBkmk.intValue());
                    continue;
                }
                table.setState(1);
                table.delete();
            }
        }
        it = metaTableCollection.entryIterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            metaTable = (MetaTable)entry.getValue();
            table = document.get(metaTable.getKey());
            DataTableMetaData metaData = table.getMetaData();
            if (metaTable.getTableMode() == 0) {
                table.first();
                int size = metaData.getColumnCount();
                for (int i = 0; i < size; ++i) {
                    ColumnInfo info = metaData.getColumnInfo(i);
                    String columnKey = info.getColumnKey();
                    MetaComponent meta = metaForm.getComponentByDataBinding(table.getKey(), columnKey);
                    if (meta != null) {
                        if (meta.isCopyNew().booleanValue()) {
                            ignoreKeys.add(meta.getKey());
                        } else {
                            table.setObject(columnKey, DocumentUtil.initValue((MetaColumn)metaTable.get(columnKey)));
                        }
                    }
                    if (!SystemField.isSystemField((String)columnKey)) continue;
                    table.setObject(columnKey, DocumentUtil.initValue((MetaColumn)metaTable.get(columnKey)));
                }
            } else {
                MetaComponent meta = metaForm.findComponentByTable(metaTable.getKey());
                if (meta != null && meta.getControlType() == 217) {
                    if (meta.isCopyNew().booleanValue()) {
                        int size = metaData.getColumnCount();
                        for (int i = 0; i < size; ++i) {
                            ColumnInfo info = metaData.getColumnInfo(i);
                            String columnKey = info.getColumnKey();
                            MetaGridCell metaCell = metaForm.getCellByDataBinding(table.getKey(), columnKey);
                            if (metaCell != null) {
                                if (!meta.isCopyNew().booleanValue() || !metaCell.isCopyNew().booleanValue()) {
                                    table.beforeFirst();
                                    while (table.next()) {
                                        table.setObject(columnKey, DocumentUtil.initValue((MetaColumn)metaTable.get(columnKey)));
                                    }
                                } else {
                                    ignoreKeys.add(metaCell.getKey());
                                }
                            }
                            if (!SystemField.isSystemField((String)columnKey)) continue;
                            table.beforeFirst();
                            while (table.next()) {
                                table.setObject(columnKey, DocumentUtil.initValue((MetaColumn)metaTable.get(columnKey)));
                            }
                        }
                    } else {
                        table.clear();
                    }
                }
            }
            table.setNew();
        }
        document.setNew();
        document.clearAllShadow();
        return ignoreKeys;
    }

    static {
        systemFields.add("OID");
        systemFields.add("POID");
        systemFields.add("SOID");
        systemFields.add("DVERID");
        systemFields.add("VERID");
        systemFields.add("InstanceID");
    }
}

