/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.tools.dict;

import com.bokesoft.yes.struct.dict.ItemRow;
import com.bokesoft.yes.struct.dict.ItemTableBase;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemUtil {
    public static List<Item> createItems(VE ve, String itemKey, Map<String, DataTable> dts) throws Throwable {
        Item item = null;
        HashMap<Long, Item> map = new HashMap<Long, Item>();
        MetaDataObject dataObj = ve.getMetaFactory().getDataObject(itemKey);
        String mainTableKey = dataObj.getMainTableKey();
        DataTable dt = dts.get(mainTableKey);
        MetaTable table = dataObj.getTable(mainTableKey);
        for (String sKey : dts.keySet()) {
            table = dataObj.getTable(sKey);
            boolean isMainTable = mainTableKey.equalsIgnoreCase(sKey);
            String SOID = table.getSOIDColumn().getBindingDBColumnName();
            dt = dts.get(sKey);
            dt.beforeFirst();
            while (dt.next()) {
                long oid = TypeConvertor.toLong((Object)dt.getObject(SOID));
                if (oid <= 0L) continue;
                item = (Item)map.get(oid);
                if (item == null) {
                    item = new Item(itemKey, oid);
                    map.put(oid, item);
                }
                ItemUtil.processData(table, dt, item, isMainTable);
            }
        }
        ArrayList<Item> list = new ArrayList<Item>();
        for (Item item2 : map.values()) {
            String caption = ItemUtil.getCaption(item2, dataObj.getDisplayColumns());
            item2.setCaption(caption);
            list.add(item2);
        }
        return list;
    }

    private static void processData(MetaTable table, DataTable dt, Item item, boolean isMainTable) {
        ItemRow row = new ItemRow();
        for (MetaColumn col : table) {
            if (!col.getCache()) continue;
            row.setValue(col.getKey(), dt.getObject(col.getBindingDBColumnName()));
        }
        String sKey = table.getKey();
        int tableMode = table.getTableMode();
        ItemTableBase tb = item.getItemTable(sKey);
        if (tb == null) {
            tb = new ItemTableBase(item.getItemKey());
            tb.setKey(sKey);
            tb.setTableMode(tableMode);
            tb.addItemRow(row);
            item.addItemTableBase(tb, isMainTable);
        } else {
            tb.addItemRow(row);
        }
    }

    private static String getCaption(Item item, List<MetaColumn> displayFields) {
        StringBuffer sb = new StringBuffer();
        if (displayFields != null && displayFields.size() > 0) {
            for (int i = 0; i < displayFields.size(); ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(TypeConvertor.toString((Object)item.getValue(displayFields.get(i).getKey())));
            }
        } else {
            sb.append(TypeConvertor.toString((Object)item.getValue("Code"))).append(" ").append(TypeConvertor.toString((Object)item.getValue("Name")));
        }
        return sb.toString();
    }
}

