/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tools.zip;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPTools {
    public static byte[] compress(byte[] value) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(bos);
            gzip.write(value);
            gzip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bos.toByteArray();
    }

    public static byte[] decompress(byte[] value) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(value);
        try {
            GZIPInputStream gzip = new GZIPInputStream(bis);
            byte[] buf = new byte[1024];
            int count = 0;
            while ((count = gzip.read(buf)) >= 0) {
                bos.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bos.toByteArray();
    }

    public static String decompress(InputStream stream, String enc) throws Throwable {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            GZIPInputStream gzip = new GZIPInputStream(stream);
            byte[] buf = new byte[1024];
            int count = 0;
            while ((count = gzip.read(buf)) >= 0) {
                bos.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bos.toString(enc);
    }

    public static void main(String[] args) throws Throwable {
        File file = new File("d:\\json.txt");
        InputStreamReader read = new InputStreamReader(new FileInputStream(file));
        BufferedReader bufferedReader = new BufferedReader(read);
        String txt = null;
        StringBuffer sb = new StringBuffer();
        while ((txt = bufferedReader.readLine()) != null) {
            sb.append(txt);
        }
        read.close();
        String json = sb.toString();
        System.out.println("11111111111111111");
        String sCur = json;
        long begin = System.currentTimeMillis();
        System.out.println("size : " + sCur.getBytes().length);
        byte[] b11 = GZIPTools.compress(sCur.getBytes());
        long end = System.currentTimeMillis();
        System.out.println("after size : " + b11.length);
        System.out.println("compress2 cost \uff1a " + (end - begin) + "ms");
        begin = System.currentTimeMillis();
        byte[] b22 = GZIPTools.decompress(b11);
        System.out.println(b22.length);
        end = System.currentTimeMillis();
        System.out.println("decompress2 cost \uff1a " + (end - begin) + "ms");
    }
}

