/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tools.json;

import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.document.Document;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class YesJSONUtil {
    public static JSONArray toJSONArray(Collection<?> collection) throws Throwable {
        if (collection == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        Iterator<?> iter = collection.iterator();
        Object value = null;
        while (iter.hasNext()) {
            value = iter.next();
            jsonArray.put((Object)YesJSONUtil.convertJSON(value));
        }
        return jsonArray;
    }

    public static List<Object> toList(JSONArray jsonArray) throws Throwable {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Object paraObj = null;
        for (int i = 0; i < jsonArray.length(); ++i) {
            paraObj = jsonArray.get(i);
            if (paraObj instanceof JSONObject) {
                list.add(YesJSONUtil.convertValue((JSONObject)paraObj));
                continue;
            }
            list.add(paraObj);
        }
        return list;
    }

    public static JSONObject toJSONObject(Map<String, Object> params) throws Throwable {
        if (params == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (param.getKey() == null || "".equals(param.getKey())) continue;
            jsonObject.put(param.getKey(), (Object)YesJSONUtil.convertJSON(param.getValue()));
        }
        return jsonObject;
    }

    public static Map<String, Object> toMap(JSONObject json) throws Throwable {
        if (json == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator it = json.keys();
        Object value = null;
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof String)) continue;
            String key = (String)o;
            value = json.get(key);
            if (value instanceof JSONObject) {
                params.put(key, YesJSONUtil.convertValue((JSONObject)value));
                continue;
            }
            params.put(key, value);
        }
        return params;
    }

    public static Object convertValue(JSONObject json) throws Throwable {
        if (!json.has("value") && !json.has("dataType")) {
            return json;
        }
        Cloneable para = json.get("value");
        if (para == JSONObject.NULL) {
            para = null;
        } else {
            switch (json.getInt("dataType")) {
                case 8: {
                    Document doc = new Document(null, -1L);
                    doc.fromJSON((JSONObject)para);
                    para = doc;
                    break;
                }
                case 9: {
                    DataTable table = new DataTable();
                    table.fromJSON((JSONObject)para);
                    para = table;
                    break;
                }
                case 12: {
                    ItemData itemData = new ItemData((JSONObject)para);
                    para = itemData;
                    break;
                }
                case 14: {
                    FileData fileData = new FileData();
                    fileData.fromJSON((JSONObject)para);
                    para = fileData;
                    break;
                }
                case 15: {
                    JSONArray array = (JSONArray)para;
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < array.length(); ++i) {
                        list.add(YesJSONUtil.convertValue((JSONObject)array.get(i)));
                    }
                    para = list;
                    break;
                }
                case 16: {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    JSONObject obj = (JSONObject)para;
                    Iterator it = obj.keys();
                    JSONObject value = null;
                    while (it.hasNext()) {
                        Object o = it.next();
                        String key = (String)o;
                        value = obj.getJSONObject(key);
                        if (value == null) continue;
                        params.put(key, YesJSONUtil.convertValue(value));
                    }
                    para = params;
                    break;
                }
                case 4: {
                    para = TypeConvertor.toBigDecimal((Object)para);
                    break;
                }
                case 7: {
                    para = TypeConvertor.toLong((Object)para);
                    break;
                }
                case 3: {
                    para = new Date(TypeConvertor.toLong((Object)para));
                    break;
                }
                case 6: {
                    para = TypeConvertor.toBoolean((Object)para);
                    break;
                }
                case 2: {
                    para = TypeConvertor.toString((Object)para);
                    break;
                }
            }
        }
        return para;
    }

    public static JSONObject convertJSON(Object para) throws Throwable {
        JSONObject paraObj = new JSONObject();
        if (para == null) {
            paraObj.put("value", JSONObject.NULL);
            paraObj.put("dataType", -1);
        } else if (para instanceof DataTable) {
            para = ((DataTable)para).toJSON();
            paraObj.put("value", para);
            paraObj.put("dataType", 9);
        } else if (para instanceof ItemData) {
            para = ((ItemData)para).toJSON();
            paraObj.put("value", para);
            paraObj.put("dataType", 12);
        } else if (para instanceof FileData) {
            para = ((FileData)para).toJSON();
            paraObj.put("value", para);
            paraObj.put("dataType", 14);
        } else if (para instanceof JSONObject) {
            paraObj.put("value", para);
            paraObj.put("dataType", 10);
        } else if (para instanceof JSONArray) {
            paraObj.put("value", para);
            paraObj.put("dataType", 11);
        } else if (para instanceof Collection) {
            JSONArray jsonArray = new JSONArray();
            Iterator iter = ((Collection)para).iterator();
            Object value = null;
            while (iter.hasNext()) {
                value = iter.next();
                jsonArray.put((Object)YesJSONUtil.convertJSON(value));
            }
            paraObj.put("value", (Object)jsonArray);
            paraObj.put("dataType", 15);
        } else if (para instanceof Map) {
            JSONObject jsonObject = new JSONObject();
            String key = null;
            Object v = null;
            for (Map.Entry param : ((Map)para).entrySet()) {
                key = TypeConvertor.toString(param.getKey());
                if (key == null || key.isEmpty() || (v = param.getValue()) == null) continue;
                jsonObject.put(key, (Object)YesJSONUtil.convertJSON(v));
            }
            paraObj.put("value", (Object)jsonObject);
            paraObj.put("dataType", 16);
        } else if (para instanceof BigDecimal || para instanceof Double || para instanceof Float) {
            paraObj.put("value", (Object)TypeConvertor.toBigDecimal((Object)para).toString());
            paraObj.put("dataType", 4);
        } else if (para instanceof Number) {
            paraObj.put("value", para);
            paraObj.put("dataType", 7);
        } else if (para instanceof Boolean) {
            paraObj.put("value", para);
            paraObj.put("dataType", 6);
        } else if (para instanceof String) {
            paraObj.put("value", para);
            paraObj.put("dataType", 2);
        } else if (para instanceof Date) {
            paraObj.put("value", ((Date)para).getTime());
            paraObj.put("dataType", 3);
        } else {
            paraObj.put("dataType", -1);
            paraObj.put("value", (Object)para.toString());
        }
        return paraObj;
    }
}

