/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tools.dic.proxy;

import com.bokesoft.yes.tools.dic.item.ICache;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.dict.Item;
import java.math.BigDecimal;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;

public class ItemSortComparator
implements Comparator<Item> {
    private ICache cache = null;

    public ItemSortComparator(ICache cache) {
        this.cache = cache;
    }

    @Override
    public int compare(Item o1, Item o2) {
        String[] sortColumns;
        int layerLevel2;
        boolean desc = false;
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1.getID() == 0L) {
            return 1;
        }
        if (o2.getID() == 0L) {
            return -1;
        }
        int layerLevel1 = this.cache.getLayerLevel(o1.getItemKey());
        if (layerLevel1 < (layerLevel2 = this.cache.getLayerLevel(o2.getItemKey()))) {
            return -1;
        }
        if (layerLevel1 > layerLevel2) {
            return 1;
        }
        try {
            sortColumns = this.cache.getSortColumns(o1.getItemKey());
        }
        catch (Throwable e) {
            e.printStackTrace();
            sortColumns = new String[]{"Code"};
        }
        for (String sortColumn : sortColumns) {
            CollationKey ck2;
            String[] keys = sortColumn.split(" +");
            if (keys.length > 1 && keys[1].equalsIgnoreCase("desc")) {
                desc = true;
            }
            Object v1 = o1.getValue(keys[0]);
            Object v2 = o2.getValue(keys[0]);
            if (this.isNumeric(v1 == null ? v2 : v1)) {
                BigDecimal bd2;
                BigDecimal bd1 = TypeConvertor.toBigDecimal((Object)v1);
                if (bd1.compareTo(bd2 = TypeConvertor.toBigDecimal((Object)v2)) == 0) continue;
                if (desc) {
                    return bd2.compareTo(bd1);
                }
                return bd1.compareTo(bd2);
            }
            String sKey1 = TypeConvertor.toString((Object)v1);
            String sKey2 = TypeConvertor.toString((Object)v2);
            CollationKey ck1 = Collator.getInstance().getCollationKey(sKey1);
            if (ck1.compareTo(ck2 = Collator.getInstance().getCollationKey(sKey2)) == 0) continue;
            if (desc) {
                return ck2.compareTo(ck1);
            }
            return ck1.compareTo(ck2);
        }
        return 0;
    }

    private boolean isNumeric(Object o) {
        boolean b = false;
        if (o instanceof Integer) {
            b = true;
        } else if (o instanceof Long) {
            b = true;
        } else if (o instanceof BigDecimal) {
            b = true;
        } else if (o instanceof Double) {
            b = true;
        } else if (o instanceof Float) {
            b = true;
        }
        return b;
    }
}

