/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tools.dic.filter;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.tools.dict.IItemFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class BaseItemFilter
implements IItemFilter {
    protected String itemKey = null;
    protected String formKey = null;
    protected String fieldKey = null;
    protected int filterIndex = -1;
    protected String typeDefKey = null;
    protected List<Integer> dataTypes = new ArrayList<Integer>();
    protected List<Object> values = new ArrayList<Object>();

    public JSONObject toJSON() throws SerializationException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("itemKey", (Object)this.itemKey);
        jsonObj.put("formKey", (Object)this.formKey);
        jsonObj.put("fieldKey", (Object)this.fieldKey);
        jsonObj.put("filterIndex", this.filterIndex);
        jsonObj.put("typeDefKey", (Object)this.typeDefKey);
        JSONArray jsonArray = new JSONArray();
        Object value = null;
        int dataType = -1;
        int size = this.values.size();
        for (int i = 0; i < size; ++i) {
            value = this.values.get(i);
            dataType = this.dataTypes.get(i);
            switch (dataType) {
                case 1003: 
                case 1004: {
                    if (!(value instanceof Date)) break;
                    value = ((Date)value).getTime();
                    break;
                }
            }
            jsonArray.put(value);
        }
        jsonObj.put("values", (Object)jsonArray);
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException {
        this.itemKey = jsonObj.getString("itemKey");
        this.formKey = jsonObj.getString("formKey");
        this.fieldKey = jsonObj.getString("fieldKey");
        if (jsonObj.has("filterIndex")) {
            this.filterIndex = jsonObj.getInt("filterIndex");
        }
        if (jsonObj.has("typeDefKey")) {
            this.typeDefKey = jsonObj.getString("typeDefKey");
        }
        JSONArray jsonArray = jsonObj.getJSONArray("values");
        this.values.clear();
        Object v = null;
        for (int i = 0; i < jsonArray.length(); ++i) {
            v = jsonArray.get(i);
            if (JSONObject.NULL.equals(v)) {
                this.values.add(null);
                continue;
            }
            this.values.add(v);
        }
    }

    public void addFilterValue(Object value) {
        this.values.add(value);
    }

    public void setItemKey(String itemKey) {
        this.itemKey = itemKey;
    }

    @Override
    public String getItemKey() {
        return this.itemKey;
    }

    public void setFieldKey(String fieldKey) {
        this.fieldKey = fieldKey;
    }

    @Override
    public String getFieldKey() {
        return this.fieldKey;
    }

    @Override
    public String getTypeDefKey() {
        return this.typeDefKey;
    }

    @Override
    public void setTypeDefKey(String typeDefKey) {
        this.typeDefKey = typeDefKey;
    }

    public void setFormKey(String key) {
        this.formKey = key;
    }

    @Override
    public String getFormKey() {
        return this.formKey;
    }

    public void setFilterIndex(int index) {
        this.filterIndex = index;
    }

    @Override
    public int getFilterIndex() {
        return this.filterIndex;
    }

    @Override
    public List<Object> getFilterValues() {
        return this.values;
    }
}

