/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.i18n;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.solution.MetaLang;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.struct.i18n.I18NInfoCacheInterface;
import com.bokesoft.yigo.struct.i18n.I18NInfoItem;
import com.bokesoft.yigo.struct.i18n.I18NInfoMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class I18NInfo {
    public static final String BaseLang_ZH = "zh-CN";
    public static final String BaseLang_EN = "en-US";
    public static final String TranslationType_Common = "Common";
    public static final String TranslationType_Component = "Component";
    public static final String TranslationType_Operation = "Operation";
    public static final String TranslationType_Entry = "Entry";
    public static final String TranslationType_BPM = "BPM";
    public static final String TranslationType_DataElement = "DataElement";
    public static final String i18nInfoTableKey = "YES_Core_I18N";
    private static I18NInfo instance;
    protected HashMap<String, I18NInfoMap> dataMap = new HashMap();
    protected I18NInfoCacheInterface cache;
    protected int version = -1;
    protected long lastModified = -1L;
    protected long lastCheckTime = -1L;

    public static I18NInfo getInstance() {
        if (instance == null) {
            instance = new I18NInfo();
        }
        return instance;
    }

    public void setCache(I18NInfoCacheInterface cache) {
        this.cache = cache;
    }

    public void resetFromCache() {
        this.version = this.cache.getVersion();
        this.lastModified = this.cache.getLastModified();
        this.lastCheckTime = new Date().getTime();
    }

    public boolean checkNeedUpdate() {
        long nowTime = new Date().getTime();
        boolean needUpdate = false;
        try {
            if (this.lastCheckTime > 0L && nowTime - this.lastCheckTime > 300000L) {
                int cache_version = this.cache.getVersion();
                long cache_lastModified = this.cache.getLastModified();
                needUpdate = this.version != cache_version || this.lastModified < cache_lastModified;
                this.lastCheckTime = nowTime;
            }
        }
        catch (Exception e) {
            this.lastCheckTime = nowTime;
            LogSvr.getInstance().error("checkNeedUpdate Error", (Throwable)e);
        }
        return needUpdate;
    }

    public void updateVersion() {
        ++this.version;
        this.cache.setVersion(this.version);
    }

    public void updateLastModified(long newLastModified) {
        if (this.lastModified < newLastModified) {
            this.lastModified = newLastModified;
            this.cache.setLastModified(this.lastModified);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void clearMap() {
        this.dataMap.clear();
    }

    public ArrayList<String> getLanguages() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.dataMap.isEmpty()) {
            return list;
        }
        I18NInfoMap map = this.dataMap.values().iterator().next();
        list.addAll(map.getChildMap().keySet());
        return list;
    }

    public I18NInfoMap getParentInfoMap(String translationType, String solutionKey, String projectKey, String formKey, String lang) {
        I18NInfoMap translationTypeMap = this.dataMap.get(translationType);
        I18NInfoMap langMap = translationTypeMap != null ? translationTypeMap.getChildByKey(lang) : null;
        I18NInfoMap solutionMap = langMap != null ? langMap.getChildByKey(solutionKey) : null;
        I18NInfoMap projectMap = solutionMap != null ? solutionMap.getChildByKey(projectKey) : null;
        return projectMap != null ? projectMap.getChildByKey(formKey) : null;
    }

    public void deleteItem(I18NInfoItem item) {
        I18NInfoMap parentMap = this.getParentInfoMap(item.getTranslationType(), item.getSolutionKey(), item.getProjectKey(), item.getFormKey(), item.getLang());
        if (parentMap != null) {
            parentMap.removeItem(item.getTranslationKey());
        }
    }

    public void addNewItem(I18NInfoItem item) {
        I18NInfoMap formMap;
        I18NInfoMap projectMap;
        I18NInfoMap solutionMap;
        I18NInfoMap langMap;
        I18NInfoMap translationTypeMap = this.dataMap.get(item.getTranslationType());
        if (translationTypeMap == null) {
            translationTypeMap = new I18NInfoMap();
            translationTypeMap.setMapType("TranslationType");
            translationTypeMap.setKey(item.getTranslationType());
            this.dataMap.put(translationTypeMap.getKey(), translationTypeMap);
        }
        if ((langMap = translationTypeMap.getChildByKey(item.getLang())) == null) {
            langMap = new I18NInfoMap();
            langMap.setMapType("Lang");
            langMap.setKey(item.getLang());
            translationTypeMap.putChildByKey(langMap.getKey(), langMap);
        }
        if ((solutionMap = langMap.getChildByKey(item.getSolutionKey())) == null) {
            solutionMap = new I18NInfoMap();
            solutionMap.setMapType("Solution");
            solutionMap.setKey(item.getSolutionKey());
            langMap.putChildByKey(solutionMap.getKey(), solutionMap);
        }
        if ((projectMap = solutionMap.getChildByKey(item.getProjectKey())) == null) {
            projectMap = new I18NInfoMap();
            projectMap.setMapType("Project");
            projectMap.setKey(item.getProjectKey());
            solutionMap.putChildByKey(projectMap.getKey(), projectMap);
        }
        if ((formMap = projectMap.getChildByKey(item.getFormKey())) == null) {
            formMap = new I18NInfoMap();
            formMap.setMapType("Form");
            formMap.setKey(item.getFormKey());
            projectMap.putChildByKey(formMap.getKey(), formMap);
        }
        formMap.putItemByKey(item.getTranslationKey(), item);
    }

    public I18NInfoItem getItem(String translationType, String translationKey, String solutionKey, String projectKey, String formKey, String lang) {
        try {
            if (solutionKey == null || solutionKey.isEmpty() || solutionKey.equals("*")) {
                solutionKey = "*";
            }
            if (projectKey == null || projectKey.isEmpty() || projectKey.equals("*")) {
                projectKey = "*";
            }
            if (formKey == null || formKey.isEmpty() || formKey.equals("*")) {
                formKey = "*";
            }
            I18NInfoItem item = null;
            I18NInfoMap parentMap = this.getParentInfoMap(translationType, solutionKey, projectKey, formKey, lang);
            if (parentMap != null) {
                item = parentMap.getItemByKey(translationKey);
            }
            if (item == null && (parentMap = this.getParentInfoMap(translationType, solutionKey, projectKey, "*", lang)) != null) {
                item = parentMap.getItemByKey(translationKey);
            }
            if (item == null && (parentMap = this.getParentInfoMap(translationType, solutionKey, "*", "*", lang)) != null) {
                item = parentMap.getItemByKey(translationKey);
            }
            if (item == null && (parentMap = this.getParentInfoMap(translationType, "*", "*", "*", lang)) != null) {
                item = parentMap.getItemByKey(translationKey);
            }
            return item;
        }
        catch (Throwable e) {
            LogSvr.getInstance().error("I18NInfo getItem", e);
            return null;
        }
    }

    public I18NInfoItem getItem(String translationType, String translationKey, String formKey, String lang) {
        try {
            String solutionKey = "*";
            String projectKey = "*";
            if (formKey == null || formKey.isEmpty() || formKey.equals("*")) {
                formKey = "*";
            } else {
                MetaFormProfile metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(formKey);
                projectKey = metaFormProfile.getProject().getKey();
                solutionKey = ((MetaSolution)((MetaProject)metaFormProfile.getProject()).getSolution()).getKey();
            }
            return this.getItem(translationType, translationKey, solutionKey, projectKey, formKey, lang);
        }
        catch (Throwable e) {
            LogSvr.getInstance().error("I18NInfo getItem", e);
            return null;
        }
    }

    private static String getTranslationType(AbstractMetaObject metaObject) {
        String translationType = TranslationType_Common;
        if (metaObject == null) {
            return translationType;
        }
        if (metaObject instanceof MetaOperation || metaObject instanceof MetaOperationCollection) {
            translationType = TranslationType_Operation;
        } else if (metaObject instanceof MetaComponent || metaObject instanceof MetaGridColumn) {
            translationType = TranslationType_Component;
        } else if (metaObject instanceof MetaEntry || metaObject instanceof MetaEntryItem) {
            translationType = TranslationType_Entry;
        }
        return translationType;
    }

    public String getLocalCaptionString(IMetaFactory metaFactory, MetaForm metaForm, String locale, String group, String word, String org, String s, MetaLang metaLang, AbstractMetaObject metaObject, boolean useFull) throws Throwable {
        I18NInfoItem i18NInfoItem;
        String baseLang;
        String result = "";
        String lang = metaLang == null ? locale : metaLang.getKey();
        String translationType = I18NInfo.getTranslationType(metaObject);
        String formKey = metaForm == null ? null : metaForm.getKey();
        String string = baseLang = metaLang == null ? BaseLang_ZH : metaLang.getBaseLang();
        if (baseLang.equals(BaseLang_EN)) {
            I18NInfoItem enItem = I18NInfo.getInstance().getItem(translationType, org, formKey, BaseLang_EN);
            if (enItem == null) {
                enItem = I18NInfo.getInstance().getItem(TranslationType_Common, org, formKey, BaseLang_EN);
            }
            if (enItem != null) {
                org = enItem.getCaption();
                if (enItem.getManualCaption() != null && !enItem.getManualCaption().isEmpty()) {
                    org = enItem.getManualCaption();
                }
            }
        }
        if ((i18NInfoItem = I18NInfo.getInstance().getItem(translationType, org, formKey, lang)) == null) {
            i18NInfoItem = I18NInfo.getInstance().getItem(TranslationType_Common, org, formKey, lang);
        }
        if (i18NInfoItem != null) {
            result = i18NInfoItem.getCaption();
            if (i18NInfoItem.getManualCaption() != null && !i18NInfoItem.getManualCaption().isEmpty()) {
                result = i18NInfoItem.getManualCaption();
            }
            if (useFull) {
                result = i18NInfoItem.getCaptionFull();
                if (i18NInfoItem.getManualCaptionFull() != null && !i18NInfoItem.getManualCaptionFull().isEmpty()) {
                    result = i18NInfoItem.getManualCaptionFull();
                }
            }
        }
        if (result.isEmpty()) {
            result = MetaUtil.getLocalString((IMetaFactory)metaFactory, (MetaForm)metaForm, (String)locale, (String)group, (String)word, (String)org, (String)s);
        }
        return result;
    }

    public String getCaptionString(IMetaFactory metaFactory, String locale, String projectKey, String group, String word, String org, MetaLang metaLang, AbstractMetaObject metaObject) throws Throwable {
        I18NInfoItem i18NInfoItem;
        String baseLang;
        MetaProject metaProject;
        String result = "";
        String lang = metaLang == null ? locale : metaLang.getKey();
        String translationType = I18NInfo.getTranslationType(metaObject);
        String solutionKey = null;
        if (projectKey != null && !projectKey.isEmpty() && (metaProject = metaFactory.getMetaProject(projectKey)) != null) {
            MetaSolution metaSolution = (MetaSolution)metaProject.getSolution();
            solutionKey = metaSolution.getKey();
        }
        String string = baseLang = metaLang == null ? BaseLang_ZH : metaLang.getBaseLang();
        if (baseLang.equals(BaseLang_EN)) {
            I18NInfoItem enItem = I18NInfo.getInstance().getItem(translationType, org, solutionKey, projectKey, null, BaseLang_EN);
            if (enItem == null) {
                enItem = I18NInfo.getInstance().getItem(TranslationType_Common, org, solutionKey, projectKey, null, BaseLang_EN);
            }
            if (enItem != null) {
                org = enItem.getCaption();
                if (enItem.getManualCaption() != null && !enItem.getManualCaption().isEmpty()) {
                    org = enItem.getManualCaption();
                }
            }
        }
        if ((i18NInfoItem = I18NInfo.getInstance().getItem(translationType, org, solutionKey, projectKey, null, lang)) == null) {
            i18NInfoItem = I18NInfo.getInstance().getItem(TranslationType_Common, org, solutionKey, projectKey, null, lang);
        }
        if (i18NInfoItem != null) {
            result = i18NInfoItem.getCaption();
            if (i18NInfoItem.getManualCaption() != null && !i18NInfoItem.getManualCaption().isEmpty()) {
                result = i18NInfoItem.getManualCaption();
            }
        }
        if (result.isEmpty()) {
            result = MetaUtil.getString((IMetaFactory)metaFactory, (String)lang, (String)projectKey, (String)group, (String)word, (String)org);
        }
        return result;
    }
}

