/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.expand.processor;

import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.struct.expand.IExpandDimensionField;
import com.bokesoft.yigo.struct.expand.IExpandSourceField;
import java.util.ArrayList;
import java.util.List;

public class DimensionItem<D extends IPairItem, S extends IExpandSourceField<F>, F extends IExpandDimensionField> {
    private D dimensionData = null;
    private S sourceField = null;
    private F dimensionField = null;
    private DimensionItem<D, S, F> parent = null;
    private ArrayList<DimensionItem<D, S, F>> children = null;

    public DimensionItem(D dimensionData, F dimensionField, S sourceField) {
        this.dimensionData = dimensionData;
        this.sourceField = sourceField;
        this.dimensionField = dimensionField;
    }

    public D getData() {
        return this.dimensionData;
    }

    public F getDimensionField() {
        return this.dimensionField;
    }

    public S getSourceField() {
        return this.sourceField;
    }

    public boolean isRoot() {
        return this.dimensionField == null;
    }

    public void setParent(DimensionItem<D, S, F> parent) {
        this.parent = parent;
    }

    public DimensionItem<D, S, F> getParent() {
        return this.parent;
    }

    public void addChild(DimensionItem<D, S, F> item) {
        this.ensureChildren().add(item);
        item.setParent(this);
    }

    public ArrayList<DimensionItem<D, S, F>> getChildren() {
        return this.ensureChildren();
    }

    private ArrayList<DimensionItem<D, S, F>> ensureChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public int getLeafCount() {
        if (this.children == null || this.children.size() == 0) {
            return 1;
        }
        int total = 0;
        for (DimensionItem<D, S, F> item : this.children) {
            total += item.getLeafCount();
        }
        return total;
    }

    public List<DimensionItem<D, S, F>> getAllLeafs() {
        ArrayList<DimensionItem<D, S, F>> list = new ArrayList<DimensionItem<D, S, F>>();
        this.loadAllLeaf(list);
        return list;
    }

    private void loadAllLeaf(List<DimensionItem<D, S, F>> list) {
        if (this.children == null || this.children.size() == 0) {
            list.add(this);
            return;
        }
        for (DimensionItem<D, S, F> item : this.children) {
            super.loadAllLeaf(list);
        }
    }

    public String getPathKey() {
        StringBuilder sb = new StringBuilder("");
        for (DimensionItem<D, S, F> item = this; item != null; item = item.getParent()) {
            sb.append("__").append(item.getData().getValue());
        }
        return sb.toString();
    }
}

