/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.struct.condition;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.struct.condition.ConditionPair;
import com.bokesoft.yes.struct.condition.ConditionPairTable;
import com.bokesoft.yigo.meta.common.MetaCondition;
import com.bokesoft.yigo.meta.common.MetaConditionTarget;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.struct.condition.CompConditionItem;
import com.bokesoft.yigo.struct.condition.ConditionItem;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class ConditionTableUtil {
    private static final void transItems(MetaForm conditionMetaForm, ConditionParas paras) {
        paras.setTransed(true);
        int size = paras.size();
        ConditionItem targetItem = null;
        MetaConditionTarget conditionTarget2 = null;
        ArrayList<ConditionItem> list = new ArrayList<ConditionItem>();
        for (int i = 0; i < size; ++i) {
            ConditionItem item = paras.get(i);
            String key = item.getKey();
            MetaComponent metaComponent = conditionMetaForm.componentByKey(key);
            MetaCondition metaCondition = metaComponent.getCondition();
            item.setMetaObject(metaCondition);
            boolean used = false;
            String tableKey = metaCondition.getTableKey();
            if (tableKey != null && !tableKey.isEmpty()) {
                targetItem = item;
                targetItem.copyValue(metaCondition);
                used = true;
            }
            for (MetaConditionTarget conditionTarget2 : metaCondition.getTargets()) {
                targetItem = used ? item.clone() : item;
                targetItem.copyValue(metaCondition);
                targetItem.setTableKey(conditionTarget2.getTableKey());
                targetItem.setColumnKey(conditionTarget2.getColumnKey());
                targetItem.setTarget(conditionTarget2.getTarget());
                if (used) {
                    list.add(targetItem);
                }
                used = true;
            }
        }
        for (ConditionItem item : list) {
            paras.add(item);
        }
    }

    public static final ConditionPairTable createPairTable(MetaForm conditionMetaForm, ConditionParas paras) throws Throwable {
        if (!paras.isTransed()) {
            ConditionTableUtil.transItems(conditionMetaForm, paras);
        }
        ConditionPairTable pairTable = new ConditionPairTable();
        StringHashMap map = new StringHashMap();
        ConditionItem condItem = null;
        int size = paras.size();
        for (int i = 0; i < size; ++i) {
            ConditionPair pair;
            ArrayList<ConditionPair> tablePairList;
            condItem = paras.get(i);
            String group = condItem.getGroup();
            String tableKey = condItem.getTableKey();
            String subTableKey = condItem.getSubTableKey();
            if (StringUtils.isNotEmpty((CharSequence)subTableKey)) {
                StringHashMap subTablePairList = pairTable.getSubPairList(tableKey);
                if (subTablePairList == null) {
                    subTablePairList = new StringHashMap();
                    pairTable.addSubPairList(tableKey, (StringHashMap<ArrayList<ConditionPair>>)subTablePairList);
                }
                tablePairList = (ArrayList<ConditionPair>)subTablePairList.get((Object)subTableKey);
                if (!subTablePairList.containsKey((Object)subTableKey)) {
                    tablePairList = new ArrayList<ConditionPair>();
                    subTablePairList.put((Object)subTableKey, tablePairList);
                }
                if (group != null && group.length() > 0) {
                    pair = (ConditionPair)map.get((Object)(tableKey + "_" + group));
                    if (pair == null) {
                        pair = new ConditionPair();
                        map.put((Object)(tableKey + "_" + group), (Object)pair);
                        tablePairList.add(pair);
                    }
                    if (condItem.isGroupHead()) {
                        pair.setHead(condItem);
                        continue;
                    }
                    pair.setTail(condItem);
                    continue;
                }
                tablePairList.add(new ConditionPair(condItem));
                continue;
            }
            tablePairList = pairTable.getPairList(tableKey);
            if (tablePairList == null) {
                tablePairList = new ArrayList();
                pairTable.addPairList(tableKey, tablePairList);
            }
            if (group != null && group.length() > 0) {
                pair = (ConditionPair)map.get((Object)(tableKey + "_" + group));
                if (pair == null) {
                    pair = new ConditionPair();
                    map.put((Object)(tableKey + "_" + group), (Object)pair);
                    tablePairList.add(pair);
                }
                if (condItem.isGroupHead()) {
                    pair.setHead(condItem);
                    continue;
                }
                pair.setTail(condItem);
                continue;
            }
            tablePairList.add(new ConditionPair(condItem));
        }
        pairTable.buildPairMap();
        ArrayList<CompConditionItem> list = null;
        CompConditionItem item = null;
        String table = null;
        for (int i = 0; i < paras.getHighItemsSize(); ++i) {
            item = paras.getHighItem(i);
            table = item.getTableKey();
            list = pairTable.getHighList(table);
            if (list == null) {
                list = new ArrayList();
                pairTable.addHighList(table, list);
            }
            list.add(item);
        }
        return pairTable;
    }
}

