/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.document;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.meta.dataobject.MetaOIDFilter;
import com.bokesoft.yigo.struct.document.TableFilterDetail;
import java.util.Collection;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FilterMap
extends StringHashMap<TableFilterDetail>
implements JSONSerializable {
    private static final long serialVersionUID = 1L;
    private int type = 1;
    private long OID = -1L;
    private boolean needDocInfo = true;
    private boolean useCursor = false;
    private boolean loadInMid = true;
    private MetaOIDFilter OIDFilter = null;

    public void setStartRow(String tableKey, int row) {
        this.getTableFilterNotNull(tableKey).setStartRow(row);
    }

    public void setMaxRows(String tableKey, int max) {
        this.getTableFilterNotNull(tableKey).setMaxRows(max);
    }

    public TableFilterDetail getTableFilterNotNull(String key) {
        TableFilterDetail t = (TableFilterDetail)this.get(key);
        if (t == null) {
            t = new TableFilterDetail(key);
            this.put(key, t);
        }
        return t;
    }

    public void setIgnoreLoad(String tableKey, boolean b) {
        this.getTableFilterNotNull(tableKey).setIgnoreLoad(b);
    }

    public TableFilterDetail getTableFilter(String key) {
        return (TableFilterDetail)this.get(key);
    }

    public void putFieldValueCondition(String key, String fieldKey, Object value) {
        this.getTableFilterNotNull(key).addFieldValueCondition(fieldKey, value);
    }

    public void appendFilterParaValue(String key, Object value) {
        this.getTableFilterNotNull(key).appendParaValue(value);
    }

    public void removeFieldValueCondition(String key, String fieldKey) {
        TableFilterDetail t = (TableFilterDetail)this.get(key);
        if (t != null) {
            t.removeFieldValueCondition(fieldKey);
        }
    }

    public void clearFieldValueCondition(String key) {
        TableFilterDetail t = (TableFilterDetail)this.get(key);
        if (t != null) {
            t.clearFieldValueCondition();
        }
    }

    public void clearAllFieldValueCondition() {
        for (TableFilterDetail t : this.values()) {
            t.clearFieldValueCondition();
        }
    }

    public void reset() {
        Collection fds = this.values();
        for (TableFilterDetail fd : fds) {
            fd.setStartRow(0);
        }
    }

    public void setOID(long OID) {
        this.OID = OID;
    }

    public long getOID() {
        return this.OID;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setNeedDocInfo(boolean b) {
        this.needDocInfo = b;
    }

    public boolean isNeedDocInfo() {
        return this.needDocInfo;
    }

    public boolean isLoadInMid() {
        return this.loadInMid;
    }

    public void setLoadInMid(boolean loadInMid) {
        this.loadInMid = loadInMid;
    }

    public JSONObject toJSON() throws SerializationException, JSONException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("type", this.type);
        jsonObj.put("OID", this.OID);
        jsonObj.put("needDocInfo", this.needDocInfo);
        JSONArray filterMapArray = new JSONArray();
        for (TableFilterDetail tableFilterDetail : this.values()) {
            filterMapArray.put((Object)tableFilterDetail.toJSON());
        }
        jsonObj.put("filterMap", (Object)filterMapArray);
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
        this.clear();
        this.type = jsonObj.getInt("type");
        this.OID = jsonObj.getLong("OID");
        this.needDocInfo = jsonObj.getBoolean("needDocInfo");
        JSONArray filterMapArray = jsonObj.getJSONArray("filterMap");
        for (int i = 0; i < filterMapArray.length(); ++i) {
            JSONObject filterObj = filterMapArray.getJSONObject(i);
            TableFilterDetail tableFilter = new TableFilterDetail();
            tableFilter.fromJSON(filterObj);
            this.put(tableFilter.getTableKey(), tableFilter);
        }
    }

    public MetaOIDFilter getOIDFilter() {
        return this.OIDFilter;
    }

    public void setOIDFilter(MetaOIDFilter oIDFilter) {
        this.OIDFilter = oIDFilter;
    }

    public void setUseCursor(boolean useCursor) {
        this.useCursor = useCursor;
    }

    public boolean isUseCursor() {
        return this.useCursor;
    }

    public Object clone() {
        FilterMap newObject = new FilterMap();
        for (Map.Entry entry : this.entrySet()) {
            newObject.put(entry.getKey(), (TableFilterDetail)((TableFilterDetail)entry.getValue()).clone());
        }
        newObject.setType(this.type);
        newObject.setOID(this.OID);
        newObject.setNeedDocInfo(this.needDocInfo);
        newObject.setUseCursor(this.useCursor);
        newObject.setLoadInMid(this.loadInMid);
        newObject.setOIDFilter(this.OIDFilter == null ? null : (MetaOIDFilter)this.OIDFilter.clone());
        return newObject;
    }
}

