/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.condition;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.condition.IConditionItem;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.exception.StructException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CompConditionItem
implements JSONSerializable,
IConditionItem {
    private int leftBrac = 0;
    private String key = "";
    private int sign = -1;
    private Object value = "";
    private int rightBrac = 0;
    private int logical = 0;
    private String tableKey = "";
    private String columnKey = "";
    private int type = -1;
    private boolean onlyDate = true;
    private String itemKey = "";
    private int stateMask = 7;
    private JSONObject filter = null;

    public CompConditionItem() {
    }

    public CompConditionItem(JSONObject jsonObj) {
        try {
            this.fromJSON(jsonObj);
        }
        catch (StructException e) {
            throw new RuntimeException("HighConditionItem JSON parse fail");
        }
    }

    public JSONObject toJSON() throws StructException, JSONException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("lBrac", this.leftBrac);
        jsonObj.put("key", (Object)this.key);
        jsonObj.put("sign", this.sign);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"type", (int)this.type, (int)-1);
        jsonObj.put("value", this.value2Json(this.type, this.value));
        jsonObj.put("rBrac", this.rightBrac);
        jsonObj.put("logical", this.logical);
        jsonObj.put("tableKey", (Object)this.tableKey);
        jsonObj.put("columnKey", (Object)this.columnKey);
        jsonObj.put("onlyDate", this.onlyDate);
        jsonObj.put("itemKey", (Object)this.itemKey);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"stateMask", (int)this.stateMask, (int)7);
        jsonObj.put("filter", (Object)this.filter);
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
        this.leftBrac = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"lBrac", (int)0);
        this.key = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"key", (String)"");
        this.sign = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"sign", (int)-1);
        this.type = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"type", (int)-1);
        this.value = this.json2Value(this.type, jsonObj.opt("value"));
        this.rightBrac = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"rBrac", (int)0);
        this.logical = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"logical", (int)0);
        this.tableKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"tableKey", (String)"");
        this.columnKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"columnKey", (String)"");
        this.onlyDate = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"onlyDate", (boolean)true);
        this.itemKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"itemKey", (String)"");
        this.stateMask = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"stateMask", (int)7);
        this.filter = jsonObj.optJSONObject("filter");
    }

    private Object value2Json(int controlType, Object value) throws SerializationException, JSONException {
        if (value == null) {
            return value;
        }
        Object ret = null;
        switch (controlType) {
            case 205: {
                ret = TypeConvertor.toDate((Object)value).getTime();
                break;
            }
            case 206: 
            case 241: 
            case 242: {
                if (value instanceof ItemData) {
                    ret = ((ItemData)value).toJSON();
                    break;
                }
                if (!(value instanceof List)) break;
                JSONArray jsonArray = new JSONArray();
                List list = (List)value;
                for (ItemData itemData : list) {
                    jsonArray.put((Object)itemData.toJSON());
                }
                ret = jsonArray;
                break;
            }
            default: {
                ret = value;
            }
        }
        return ret;
    }

    private Object json2Value(int controlType, Object value) throws StructException, JSONException {
        ArrayList<ItemData> ret = null;
        switch (controlType) {
            case 205: {
                ret = new Date(TypeConvertor.toLong((Object)value));
                break;
            }
            case 206: 
            case 241: 
            case 242: {
                if (value instanceof JSONArray) {
                    ArrayList<ItemData> list = new ArrayList<ItemData>();
                    JSONArray jsonArray = (JSONArray)value;
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject itemObj = jsonArray.getJSONObject(i);
                        list.add(new ItemData(itemObj));
                    }
                    ret = list;
                    break;
                }
                if (!(value instanceof JSONObject)) break;
                ret = new ItemData((JSONObject)value);
                break;
            }
            default: {
                ret = value;
            }
        }
        return ret;
    }

    public int getLeftBrac() {
        return this.leftBrac;
    }

    public void setLeftBrac(int leftBrac) {
        this.leftBrac = leftBrac;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getSign() {
        return this.sign;
    }

    public void setSign(int sign) {
        this.sign = sign;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int getRightBrac() {
        return this.rightBrac;
    }

    public void setRightBrac(int rightBrac) {
        this.rightBrac = rightBrac;
    }

    public int getLogical() {
        return this.logical;
    }

    public void setLogical(int logical) {
        this.logical = logical;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isOnlyDate() {
        return this.onlyDate;
    }

    public void setOnlyDate(boolean onlyDate) {
        this.onlyDate = onlyDate;
    }

    @Override
    public String getItemKey() {
        return this.itemKey;
    }

    public void setItemKey(String itemKey) {
        this.itemKey = itemKey;
    }

    @Override
    public int getStateMask() {
        return this.stateMask;
    }

    public void setStateMask(int stateMask) {
        this.stateMask = stateMask;
    }

    @Override
    public JSONObject getFilter() {
        return this.filter;
    }

    public void setFilter(JSONObject filter) {
        this.filter = filter;
    }

    public void setTableKey(String tableKey) {
        this.tableKey = tableKey;
    }

    public String getTableKey() {
        return this.tableKey;
    }

    public void setColumnKey(String columnKey) {
        this.columnKey = columnKey;
    }

    public String getColumnKey() {
        return this.columnKey;
    }
}

