package com.bokesoft.yigo.struct.util;

import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;

/**
 * DataTableCreator创建数据表的实用类，根据表标识和类型创建空的数据表
 * @author wangyh
 *
 */
public class DataTableCreator {
	/**
	 * 创建列信息创建表
	 * @param columnInfos 列信息，格式为
	 * <pre>
	 * { 
	 * 	{   key1, type1 }
	 * 	{	key2, type2 }
	 * }
	 * </pre>
	 * 形式
	 * @return 数据表
	 */
	public static DataTable create(Object[][] columnInfos) {
		DataTable table = new DataTable();
		for ( int i = 0, size = columnInfos.length; i<size; ++i ) {
			Object[] v = columnInfos[i];
			String key = (String)v[0];
			int type = (Integer)v[1];
			ColumnInfo c = new ColumnInfo(key, type);
			table.addColumn(c);
		}
		return table;
	}
}
