package com.bokesoft.yigo.struct.rights;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yigo.common.json.JSONSerializable;

/**
 * 自定义操作权限对象
 * 
 * @author wubh
 *
 */
public class CustomRights implements JSONSerializable {
	/** 是否拥有所有权限 */
	private boolean hasAllRights = false;
	
	private Map<String, Set<String>> rightLists = new HashMap<String, Set<String>>();

	public Map<String, Set<String>> getRightLists() {
		return rightLists;
	}

	public void setRightLists(Map<String, Set<String>> rightLists) {
		this.rightLists = rightLists;
	}

	public void addRights(String groupKey, String optKey) {
		if (hasAllRights) {
			return;
		}
		if(groupKey.equalsIgnoreCase("*")){
			hasAllRights = true;
		}else if (!this.contains(groupKey, optKey)) {
			getGroup(groupKey).add(optKey);
		}
	}

	public void removeRights(String groupKey, String optKey) {
		getGroup(groupKey).remove(optKey);
	}

	public boolean contains(String groupKey, String optKey) {
		if (hasAllRights) {
			return true;
		}
		return getGroup(groupKey).contains(optKey);
	}

	private Set<String> getGroup(String groupKey) {
		Set<String> s = rightLists.get(groupKey);
		if (s == null)
			rightLists.put(groupKey, s = new HashSet<>());
		return s;
	}

	public CustomRights clone(){
		CustomRights clone = new CustomRights();
		clone.merge(this);
		return clone;
	}
	
	public void merge(CustomRights cr) {
		if(cr == null){
			return;
		}
		
		if (!hasAllRights && cr.hasAllRights)
			hasAllRights = cr.hasAllRights;

		for (Map.Entry<String, Set<String>> en : cr.rightLists.entrySet()) {

			Set<String> s = rightLists.get(en.getKey());
			if (s == null)
				rightLists.put(en.getKey(), en.getValue());
			else
				s.addAll(en.getValue());

		}

	}

	public boolean isHasAllRights() {
		return hasAllRights;
	}

	public void setHasAllRights(boolean hasAllRights) {
		this.hasAllRights = hasAllRights;
	}

	public Set<Entry<String, Set<String>>> CustomRightsSet() {
		return rightLists.entrySet();
	}
	

	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject jsonObj = new JSONObject();
		if (this.hasAllRights) {
			jsonObj.put(RightsJSONConstants.CUSTOMRIGHTS_ALLRIGHTS, true);
		} else {
	        JSONObject rightsJSON = new JSONObject();
	        Set<String> set = null;
	        String key = null;
	        for (Map.Entry<String, Set<String>> param : rightLists.entrySet()) {
	        	key = param.getKey();
	        	set = param.getValue();
	            if ((key != null && !key.isEmpty())
	            && (set != null && !set.isEmpty())) {
	                rightsJSON.put(param.getKey(), toJSONArray(set));
	            }
	        }
			
			//jsonObj.put(RightsJSONConstants.CUSTOMRIGHTS_ALLRIGHTS, rightsJSON);
	        jsonObj.put(RightsJSONConstants.CUSTOMRIGHTS_ALLRIGHTS, false);
	        jsonObj.put(RightsJSONConstants.CUSTOMRIGHTS_RIGHTSLIST, rightsJSON);
		}
		return jsonObj;
	}
	

	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		this.hasAllRights = JSONHelper.readFromJSON(jsonObj, RightsJSONConstants.CUSTOMRIGHTS_ALLRIGHTS, false);
		
		if(!this.hasAllRights){
			JSONObject json = jsonObj.optJSONObject(RightsJSONConstants.CUSTOMRIGHTS_RIGHTSLIST);
			if(json != null){
				this.rightLists = toMap(json);
			}
		}
	}
	private Map<String, Set<String>> toMap(JSONObject jsonObj) throws Throwable{

        Map<String, Set<String>> map = new HashMap<String, Set<String>>();
  
        Iterator<?> it = jsonObj.keys();
        JSONArray jsonArray = null;
        Set<String> set = null;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof String) {
                String key = (String)o;
                jsonArray = jsonObj.getJSONArray(key);
            	if(jsonArray != null && jsonArray.length() > 0){
            		set = new HashSet<String>();
            		for(int i = 0 ; i < jsonArray.length() ; i ++){
            			set.add(jsonArray.getString(i));
            		}
            		map.put(key, set);
    			}
            }
        }
        return map;
	}
	
    private JSONArray toJSONArray(Collection<?> collection) throws Throwable{
    	 
		if(collection == null){
			return null;
		}
		
		JSONArray jsonArray = new JSONArray();

        Iterator<?> iter = collection.iterator();
        Object value = null;
        while (iter.hasNext()) {
        	value = iter.next();
			jsonArray.put(value);
        }
        return jsonArray;
    }


}
