package com.bokesoft.yigo.struct.exception;

import com.bokesoft.yigo.common.exception.CoreException;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.struct.i18n.StringTable;

/**
 * StructException定义基础数据结构异常，
 * 大类编号:8002
 * 异常编码如下:
 * <ul>
 * <li>0001 - 游标越界
 * <li>0002 - 列的错误
 * <li>0003 - 未定义的数据类型
 * </ul>
 * @author liux
 * 
 */
public class StructException extends CoreException {

	private static final long serialVersionUID = 1L;

	/**
	 * 游标越界
	 */
	public static final int OUT_OF_BOUNDS = 0x0001;

	/**
	 * JSON数组中列的数量与表格配置定义不符
	 */
	public static final int COLUMN_NUMBER_ERROR = 0x0002;

	/**
	 * 未定义的数据类型
	 */
	public static final int UNDEFINED = 0x0003;
	
	/**
	 * 列的键值错误
	 */
	public static final int COLUMN_KEY_ERROR = 0x0004;
	
	/**
	 * 二进制字段不支持排序操作
	 */
	public static final int CANNOT_SORT = 0x0005;
	
	/**
	 * 未找到指定列
	 */
	public static final int UNFINDED_COLUMN = 0x0006;
	
	/**
	 * 列值克隆错误
	 */
	public static final int COLUMN_CLONE_ERROR = 0x0007;
	
	/**
	 * 列长度超过metaTable中定义的长度
	 */
	public static final int COLUMN_LENGTH_ERROR = 0x0008;

	public StructException(int code, String message) {
		super(code, message);
	}

	@Override
	protected int getGroupCode() {
		return 0x8002;
	}

	public static String formatMessage(ILocale locale, int code, Object ...args) {
		String message = null;
		String format = null;
		switch ( code ) {
		case OUT_OF_BOUNDS:
			format = StringTable.getString(locale, "", StringTable.OutOfBoubds);
			break;
		case COLUMN_NUMBER_ERROR:
			format = StringTable.getString(locale, "", StringTable.ColumnNumberError);
			break;
		case UNDEFINED:
			format = StringTable.getString(locale, "", StringTable.Undefined);
			break;
		case COLUMN_KEY_ERROR:
			format = StringTable.getString(locale, "", StringTable.ColumnKeyError);
			break;
		case CANNOT_SORT:
			format = StringTable.getString(locale, "", StringTable.CannotSort);
			break;
		case UNFINDED_COLUMN:
			format = StringTable.getString(locale, "", StringTable.UnfindedColumn);
			break;
		case COLUMN_CLONE_ERROR:
			format = StringTable.getString(locale, "", StringTable.ColumnCloneError);
			break;
		case COLUMN_LENGTH_ERROR:
			format = StringTable.getString(locale, "", StringTable.ColumnLengthError);
			break;
		}	
		message = SimpleStringFormat.format(format, args);
		return message;
	}
}
