package com.bokesoft.yigo.struct.document;

import com.bokesoft.yes.common.struct.StringHashMap;

/**
 * 保存时的数据过滤条件
 * 
 * @author 刘翔翔
 *
 */
public class SaveFilterMap extends StringHashMap<TableSaveFilterDetail> {

	private static final long serialVersionUID = 1L;

	public TableSaveFilterDetail setTableFilterType(String tableKey, int type) {
		TableSaveFilterDetail detail = get(tableKey);
		if (detail == null) {
			detail = new TableSaveFilterDetail();
			put(tableKey, detail);
		}
		detail.setSaveType(type);
		return detail;
	}

	public void putField(String tableKey, String fieldKey) {
		TableSaveFilterDetail detail = get(tableKey);
		if (detail == null) {
			detail = new TableSaveFilterDetail();
			put(tableKey, detail);
		}
		detail.addFieldKey(fieldKey);
	}

}
