package com.bokesoft.yigo.struct.attachment;

import java.util.Date;

import org.json.JSONObject;

import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.json.JSONSerializable;

public class Attachment implements JSONSerializable {
	private long uploadOperator;
	private Date uploadTime;
	private String filePath;
	private String fileName;
	private int fileSize;
	
	public Attachment() {
	}
	
	public Attachment(long uploadOperator, Date uploadTime, String filePath, String fileName) {
		super();
		this.uploadOperator = uploadOperator;
		this.uploadTime = uploadTime;
		this.filePath = filePath;
		this.fileName = fileName;
		this.fileSize = fileSize;
	}
	
	public Object get(String field) {
		switch (field) {
		case SystemField.UPLOAD_OPERATOR:
			return uploadOperator;
		case SystemField.UPLOAD_TIME:
			return uploadTime;
		case SystemField.UPLOAD_PATH:
			return filePath;
		case SystemField.UPLOAD_FILENAME:
			return fileName;
		case SystemField.UPLOAD_FILESIZE:
			return fileSize;
		default:
			break;
		}
		return null;
	}
	
	public long getUploadOperator() {
		return uploadOperator;
	}
	public void setUploadOperator(long uploadOperator) {
		this.uploadOperator = uploadOperator;
	}
	public Date getUploadTime() {
		return uploadTime;
	}
	public void setUploadTime(Date uploadTime) {
		this.uploadTime = uploadTime;
	}
	public String getFilePath() {
		return filePath;
	}
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}
	public String getFileName() {
		return fileName;
	}
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
	public int getFileSize() {
		return fileSize;
	}
	public void setFileSize(int fileSize) {
		this.fileSize = fileSize;
	}
	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject o = new JSONObject();
		o.put("UploadOperator", uploadOperator);
		o.put("UploadTime", uploadTime.getTime());
		o.put("Path", filePath);
		o.put("Name", fileName);
		o.put("FileSize", fileSize);
		return o;
	}
	
	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		this.uploadOperator = jsonObj.getLong("UploadOperator");
		this.uploadTime = new Date(jsonObj.getLong("UploadTime"));
		this.filePath = jsonObj.getString("Path");
		this.fileName = jsonObj.getString("Name");
		this.fileSize = jsonObj.getInt("FileSize");
	}
}
