/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfoCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.util.Date;

public class DeployDBProcess {
    public static final int ALREADY_DEPLOY = 1;
    public static final int UNDEPLOY = 0;
    private MetaProcess metaProcess = null;

    public DeployDBProcess() {
    }

    public DeployDBProcess(MetaProcess metaProcess) {
        this.metaProcess = metaProcess;
    }

    public void deploy(DefaultContext defaultContext) throws Throwable {
        String string = this.metaProcess.getKey();
        int n2 = this.metaProcess.getVersion();
        IMetaFactory iMetaFactory = defaultContext.getVE().getMetaFactory();
        if (iMetaFactory.getMetaBPM() == null) {
            return;
        }
        MetaProcessDeployInfoCollection metaProcessDeployInfoCollection = iMetaFactory.getMetaBPM().getMetaBPMDeployInfoCollection();
        if (metaProcessDeployInfoCollection.containsKey(string) && ((MetaProcessDeployInfo)metaProcessDeployInfoCollection.get(string)).getVersion() == n2) {
            throw BPMError.getBPMError((ILocale)defaultContext.getEnv(), (int)54, (Object[])new Object[]{string, n2});
        }
        this.checkDBProcess(defaultContext, string, n2);
        this.signAlreadyDeploy(defaultContext, string, n2);
        defaultContext = new MetaProcessDeployInfo();
        defaultContext.setKey(string);
        defaultContext.setVersion(Integer.valueOf(n2));
        defaultContext.setInitDate(DateFormat.getDateTimeInstance().format(new Date()));
        iMetaFactory.getMetaBPM().getMetaBPMDeployInfoCollection().add((KeyPairMetaObject)defaultContext);
    }

    private void checkDBProcess(DefaultContext defaultContext, String string, int n2) throws Throwable {
        ResultSet resultSet;
        block6: {
            IDBManager iDBManager = defaultContext.getDBManager();
            String string2 = "select * from BPM_Process where ProcessKey=? and VerID=?";
            PreparedStatement preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = iDBManager.preparedQueryStatement(string2);
                PSArgs pSArgs = new PSArgs();
                pSArgs.addStringArg(string);
                pSArgs.addIntArg(Integer.valueOf(n2));
                resultSet = iDBManager.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
                if (!resultSet.next()) {
                    throw BPMError.getBPMError((ILocale)defaultContext.getEnv(), (int)50, (Object[])new Object[0]);
                }
                if (preparedStatement == null) break block6;
            }
            catch (Throwable throwable) {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                throw throwable;
            }
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
            return;
        }
    }

    private void signAlreadyDeploy(DefaultContext defaultContext, String string, int n2) throws Throwable {
        ResultSet resultSet;
        block7: {
            IDBManager iDBManager = defaultContext.getDBManager();
            String string2 = "select AlreadyDeploy,VerID from BPM_Process where ProcessKey=?";
            PreparedStatement preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = iDBManager.preparedQueryStatement(string2);
                PSArgs pSArgs = new PSArgs();
                pSArgs.addStringArg(string);
                resultSet = iDBManager.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
                while (resultSet.next()) {
                    int n3 = resultSet.getInt(1);
                    int n4 = resultSet.getInt(2);
                    if (n2 == n4) {
                        if (n3 == 1) continue;
                        this.updateDeploy(defaultContext, string, n2, 1);
                        continue;
                    }
                    if (n3 != 1) continue;
                    this.updateDeploy(defaultContext, string, n4, 0);
                }
                if (preparedStatement == null) break block7;
            }
            catch (Throwable throwable) {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                throw throwable;
            }
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateDeploy(DefaultContext defaultContext, String string, int n2, int n3) throws Throwable {
        defaultContext = defaultContext.getDBManager();
        String string2 = "update BPM_Process set AlreadyDeploy=? where ProcessKey=? and VerID=?";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = defaultContext.preparedUpdateStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addIntArg(Integer.valueOf(n3));
            pSArgs.addStringArg(string);
            pSArgs.addIntArg(Integer.valueOf(n2));
            defaultContext.executeUpdate(preparedStatement, string2, (QueryArguments)pSArgs);
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    public void setProcess(MetaProcess metaProcess) {
        this.metaProcess = metaProcess;
    }

    public MetaProcess getProcess() {
        return this.metaProcess;
    }
}

